# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.gpu_request_type import GpuRequestType
from runai.models.mig_profile import MigProfile
from runai.models.request_resource_cores import RequestResourceCores
from runai.models.request_resource_quantity import RequestResourceQuantity
from runai.models.workloads_extended_resource import WorkloadsExtendedResource
from typing import Optional, Set
from typing_extensions import Self


class PodRequestResources(BaseModel):
    """
    Pydantic class model representing PodRequestResources.

    Parameters:
        ```python
        gpu_request_type: Optional[GpuRequestType]
        gpu: Optional[RequestResourceCores]
        gpu_memory: Optional[RequestResourceQuantity]
        cpu: Optional[RequestResourceCores]
        cpu_memory: Optional[RequestResourceQuantity]
        mig_profile: Optional[MigProfile]
        extended_resources: Optional[List[WorkloadsExtendedResource]]
        ```
        gpu_request_type: See model GpuRequestType for more information.
        gpu: See model RequestResourceCores for more information.
        gpu_memory: See model RequestResourceQuantity for more information.
        cpu: See model RequestResourceCores for more information.
        cpu_memory: See model RequestResourceQuantity for more information.
        mig_profile: See model MigProfile for more information.
        extended_resources: Set of extended resources with their quantity
    Example:
        ```python
        PodRequestResources(
            gpu_request_type='portion',
                        gpu=runai.models.request_resource_cores.RequestResourceCores(
                    limit = 1.5,
                    request = 1, ),
                        gpu_memory=runai.models.request_resource_quantity.RequestResourceQuantity(
                    limit = '2G',
                    request = '200M', ),
                        cpu=runai.models.request_resource_cores.RequestResourceCores(
                    limit = 1.5,
                    request = 1, ),
                        cpu_memory=runai.models.request_resource_quantity.RequestResourceQuantity(
                    limit = '2G',
                    request = '200M', ),
                        mig_profile='1g.5gb',
                        extended_resources=[
                    runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                        resource = 'hardware-vendor.example/foo',
                        quantity = '2',
                        exclude = False, )
                    ]
        )
        ```
    """  # noqa: E501

    gpu_request_type: Optional[GpuRequestType] = Field(
        default=None, alias="gpuRequestType"
    )
    gpu: Optional[RequestResourceCores] = None
    gpu_memory: Optional[RequestResourceQuantity] = Field(
        default=None, alias="gpuMemory"
    )
    cpu: Optional[RequestResourceCores] = None
    cpu_memory: Optional[RequestResourceQuantity] = Field(
        default=None, alias="cpuMemory"
    )
    mig_profile: Optional[MigProfile] = Field(default=None, alias="migProfile")
    extended_resources: Optional[List[Optional[WorkloadsExtendedResource]]] = Field(
        default=None,
        description="Set of extended resources with their quantity",
        alias="extendedResources",
    )
    __properties: ClassVar[List[str]] = [
        "gpuRequestType",
        "gpu",
        "gpuMemory",
        "cpu",
        "cpuMemory",
        "migProfile",
        "extendedResources",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PodRequestResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of gpu
        if self.gpu:
            _dict["gpu"] = self.gpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_memory
        if self.gpu_memory:
            _dict["gpuMemory"] = self.gpu_memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict["cpu"] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_memory
        if self.cpu_memory:
            _dict["cpuMemory"] = self.cpu_memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in extended_resources (list)
        _items = []
        if self.extended_resources:
            for _item_extended_resources in self.extended_resources:
                if _item_extended_resources:
                    _items.append(_item_extended_resources.to_dict())
            _dict["extendedResources"] = _items
        # set to None if gpu_request_type (nullable) is None
        # and model_fields_set contains the field
        if (
            self.gpu_request_type is None
            and "gpu_request_type" in self.model_fields_set
        ):
            _dict["gpuRequestType"] = None

        # set to None if gpu (nullable) is None
        # and model_fields_set contains the field
        if self.gpu is None and "gpu" in self.model_fields_set:
            _dict["gpu"] = None

        # set to None if gpu_memory (nullable) is None
        # and model_fields_set contains the field
        if self.gpu_memory is None and "gpu_memory" in self.model_fields_set:
            _dict["gpuMemory"] = None

        # set to None if cpu (nullable) is None
        # and model_fields_set contains the field
        if self.cpu is None and "cpu" in self.model_fields_set:
            _dict["cpu"] = None

        # set to None if cpu_memory (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_memory is None and "cpu_memory" in self.model_fields_set:
            _dict["cpuMemory"] = None

        # set to None if mig_profile (nullable) is None
        # and model_fields_set contains the field
        if self.mig_profile is None and "mig_profile" in self.model_fields_set:
            _dict["migProfile"] = None

        # set to None if extended_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.extended_resources is None
            and "extended_resources" in self.model_fields_set
        ):
            _dict["extendedResources"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PodRequestResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "gpuRequestType": obj.get("gpuRequestType"),
                "gpu": (
                    RequestResourceCores.from_dict(obj["gpu"])
                    if obj.get("gpu") is not None
                    else None
                ),
                "gpuMemory": (
                    RequestResourceQuantity.from_dict(obj["gpuMemory"])
                    if obj.get("gpuMemory") is not None
                    else None
                ),
                "cpu": (
                    RequestResourceCores.from_dict(obj["cpu"])
                    if obj.get("cpu") is not None
                    else None
                ),
                "cpuMemory": (
                    RequestResourceQuantity.from_dict(obj["cpuMemory"])
                    if obj.get("cpuMemory") is not None
                    else None
                ),
                "migProfile": obj.get("migProfile"),
                "extendedResources": (
                    [
                        WorkloadsExtendedResource.from_dict(_item)
                        for _item in obj["extendedResources"]
                    ]
                    if obj.get("extendedResources") is not None
                    else None
                ),
            }
        )
        return _obj
