# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.allocated_resources import AllocatedResources
from runai.models.container1 import Container1
from runai.models.pod_node_affinity import PodNodeAffinity
from runai.models.pod_request_resources import PodRequestResources
from runai.models.pod_toleration import PodToleration
from typing import Optional, Set
from typing_extensions import Self


class PodSyncFields(BaseModel):
    """
    Pydantic class model representing PodSyncFields.

    Parameters:
        ```python
        name: str
        priority_class_name: str
        id: str
        workload_id: str
        revision_id: Optional[str]
        cluster_id: str
        project_id: str
        node_name: Optional[str]
        created_at: datetime
        completed_at: Optional[datetime]
        containers: List[Container1]
        current_node_pool: Optional[str]
        requested_node_pools: List[str]
        requested_resources: Optional[PodRequestResources]
        allocated_resources: Optional[AllocatedResources]
        tolerations: List[PodToleration]
        k8s_phase: str
        ip: Optional[str]
        node_affinity: PodNodeAffinity
        ```
        name: See model str for more information.
        priority_class_name: See model str for more information.
        id: See model str for more information.
        workload_id: See model str for more information.
        revision_id: See model str for more information.
        cluster_id: The id of the cluster.
        project_id: See model str for more information.
        node_name: See model str for more information.
        created_at: See model datetime for more information.
        completed_at: See model datetime for more information.
        containers: See model List[Container1] for more information.
        current_node_pool: See model str for more information.
        requested_node_pools: See model List[str] for more information.
        requested_resources: See model PodRequestResources for more information.
        allocated_resources: See model AllocatedResources for more information.
        tolerations: See model List[PodToleration] for more information.
        k8s_phase: See model str for more information.
        ip: See model str for more information.
        node_affinity: See model PodNodeAffinity for more information.
    Example:
        ```python
        PodSyncFields(
            name='pod-of-a-very-important-job',
                        priority_class_name='high-priority',
                        id='',
                        workload_id='',
                        revision_id='',
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        project_id='1',
                        node_name='gpu-node-1',
                        created_at='2022-01-01T03:49:52.531Z',
                        completed_at='2022-01-01T03:49:52.531Z',
                        containers=[
                    runai.models.container1.Container1(
                        name = 'alpine',
                        image = 'alpine:latest',
                        started_at = '2022-01-01T03:49:52.531Z', )
                    ],
                        current_node_pool='default',
                        requested_node_pools=[
                    'default'
                    ],
                        requested_resources=runai.models.pod_request_resources.PodRequestResources(
                    gpu_request_type = 'portion',
                    gpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    gpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    cpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    cpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    mig_profile = '1g.5gb',
                    extended_resources = [
                        runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                            resource = 'hardware-vendor.example/foo',
                            quantity = '2',
                            exclude = False, )
                        ], ),
                        allocated_resources=runai.models.allocated_resources.AllocatedResources(
                    gpu = 1.5,
                    mig_profile = '1g.5gb',
                    gpu_memory = '200Mi',
                    cpu = 0.5,
                    cpu_memory = '0B',
                    extended_resources = [
                        runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                            resource = 'hardware-vendor.example/foo',
                            quantity = '2',
                            exclude = False, )
                        ], ),
                        tolerations=[
                    runai.models.pod_toleration.PodToleration(
                        key = '',
                        operator = 'Exists',
                        value = '',
                        effect = 'NoExecute',
                        toleration_seconds = 10, )
                    ],
                        k8s_phase='Pending',
                        ip='10.244.1.1',
                        node_affinity=runai.models.pod_node_affinity.PodNodeAffinity(
                    required = runai.models.pod_node_affinity_required.PodNodeAffinity_required(
                        node_selector_terms = [
                            runai.models.node_selector_term.NodeSelectorTerm(
                                match_expressions = [
                                    runai.models.match_expression.MatchExpression(
                                        key = '',
                                        operator = 'In',
                                        values = [
                                            ''
                                            ], )
                                    ], )
                            ], ),
                    preferred = runai.models.pod_node_affinity_preferred.PodNodeAffinity_preferred(), )
        )
        ```
    """  # noqa: E501

    name: StrictStr
    priority_class_name: StrictStr = Field(alias="priorityClassName")
    id: StrictStr
    workload_id: StrictStr = Field(alias="workloadId")
    revision_id: Optional[StrictStr] = Field(default=None, alias="revisionId")
    cluster_id: StrictStr = Field(
        description="The id of the cluster.", alias="clusterId"
    )
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    node_name: Optional[StrictStr] = Field(default=None, alias="nodeName")
    created_at: datetime = Field(alias="createdAt")
    completed_at: Optional[datetime] = Field(default=None, alias="completedAt")
    containers: List[Container1]
    current_node_pool: Optional[StrictStr] = Field(
        default=None, alias="currentNodePool"
    )
    requested_node_pools: Optional[List[StrictStr]] = Field(
        default=None, alias="requestedNodePools"
    )
    requested_resources: Optional[PodRequestResources] = Field(
        default=None, alias="requestedResources"
    )
    allocated_resources: Optional[AllocatedResources] = Field(
        default=None, alias="allocatedResources"
    )
    tolerations: Optional[List[PodToleration]] = None
    k8s_phase: StrictStr = Field(alias="k8sPhase")
    ip: Optional[StrictStr] = None
    node_affinity: Optional[PodNodeAffinity] = Field(default=None, alias="nodeAffinity")
    __properties: ClassVar[List[str]] = [
        "name",
        "priorityClassName",
        "id",
        "workloadId",
        "revisionId",
        "clusterId",
        "projectId",
        "nodeName",
        "createdAt",
        "completedAt",
        "containers",
        "currentNodePool",
        "requestedNodePools",
        "requestedResources",
        "allocatedResources",
        "tolerations",
        "k8sPhase",
        "ip",
        "nodeAffinity",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PodSyncFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in containers (list)
        _items = []
        if self.containers:
            for _item_containers in self.containers:
                if _item_containers:
                    _items.append(_item_containers.to_dict())
            _dict["containers"] = _items
        # override the default output from pydantic by calling `to_dict()` of requested_resources
        if self.requested_resources:
            _dict["requestedResources"] = self.requested_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allocated_resources
        if self.allocated_resources:
            _dict["allocatedResources"] = self.allocated_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tolerations (list)
        _items = []
        if self.tolerations:
            for _item_tolerations in self.tolerations:
                if _item_tolerations:
                    _items.append(_item_tolerations.to_dict())
            _dict["tolerations"] = _items
        # override the default output from pydantic by calling `to_dict()` of node_affinity
        if self.node_affinity:
            _dict["nodeAffinity"] = self.node_affinity.to_dict()
        # set to None if revision_id (nullable) is None
        # and model_fields_set contains the field
        if self.revision_id is None and "revision_id" in self.model_fields_set:
            _dict["revisionId"] = None

        # set to None if node_name (nullable) is None
        # and model_fields_set contains the field
        if self.node_name is None and "node_name" in self.model_fields_set:
            _dict["nodeName"] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict["completedAt"] = None

        # set to None if current_node_pool (nullable) is None
        # and model_fields_set contains the field
        if (
            self.current_node_pool is None
            and "current_node_pool" in self.model_fields_set
        ):
            _dict["currentNodePool"] = None

        # set to None if requested_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.requested_resources is None
            and "requested_resources" in self.model_fields_set
        ):
            _dict["requestedResources"] = None

        # set to None if allocated_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allocated_resources is None
            and "allocated_resources" in self.model_fields_set
        ):
            _dict["allocatedResources"] = None

        # set to None if ip (nullable) is None
        # and model_fields_set contains the field
        if self.ip is None and "ip" in self.model_fields_set:
            _dict["ip"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PodSyncFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "priorityClassName": obj.get("priorityClassName"),
                "id": obj.get("id"),
                "workloadId": obj.get("workloadId"),
                "revisionId": obj.get("revisionId"),
                "clusterId": obj.get("clusterId"),
                "projectId": obj.get("projectId"),
                "nodeName": obj.get("nodeName"),
                "createdAt": obj.get("createdAt"),
                "completedAt": obj.get("completedAt"),
                "containers": (
                    [Container1.from_dict(_item) for _item in obj["containers"]]
                    if obj.get("containers") is not None
                    else None
                ),
                "currentNodePool": obj.get("currentNodePool"),
                "requestedNodePools": obj.get("requestedNodePools"),
                "requestedResources": (
                    PodRequestResources.from_dict(obj["requestedResources"])
                    if obj.get("requestedResources") is not None
                    else None
                ),
                "allocatedResources": (
                    AllocatedResources.from_dict(obj["allocatedResources"])
                    if obj.get("allocatedResources") is not None
                    else None
                ),
                "tolerations": (
                    [PodToleration.from_dict(_item) for _item in obj["tolerations"]]
                    if obj.get("tolerations") is not None
                    else None
                ),
                "k8sPhase": obj.get("k8sPhase"),
                "ip": obj.get("ip"),
                "nodeAffinity": (
                    PodNodeAffinity.from_dict(obj["nodeAffinity"])
                    if obj.get("nodeAffinity") is not None
                    else None
                ),
            }
        )
        return _obj
