# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.distributed_policy_v2 import DistributedPolicyV2
from runai.models.inference_policy_v2 import InferencePolicyV2
from runai.models.training_policy_v2 import TrainingPolicyV2
from runai.models.workspace_policy_v2 import WorkspacePolicyV2
from typing import Optional, Set
from typing_extensions import Self


class PolicyCrossType(BaseModel):
    """
    Pydantic class model representing PolicyCrossType.

    Parameters:
        ```python
        workspace: Optional[WorkspacePolicyV2]
        training: Optional[TrainingPolicyV2]
        distributed: Optional[DistributedPolicyV2]
        inference: Optional[InferencePolicyV2]
        ```
        workspace: See model WorkspacePolicyV2 for more information.
        training: See model TrainingPolicyV2 for more information.
        distributed: See model DistributedPolicyV2 for more information.
        inference: See model InferencePolicyV2 for more information.
    Example:
        ```python
        PolicyCrossType(
            workspace=runai.models.workspace_policy_v2.WorkspacePolicyV2(
                    meta = null,
                    policy = runai.models.workspace_policy_defaults_and_rules_v2.WorkspacePolicyDefaultsAndRulesV2(
                        defaults = runai.models.workspace_policy_defaults_and_rules_v2_defaults.WorkspacePolicyDefaultsAndRulesV2_defaults(),
                        rules = runai.models.rules.rules(),
                        imposed_assets = [
                            ''
                            ],
                        status = runai.models.policy_validation_status.PolicyValidationStatus(
                            validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                                error_message = '', ), ), ),
                    effective = runai.models.workspace_policy_defaults_and_rules_v2.WorkspacePolicyDefaultsAndRulesV2(
                        rules = runai.models.rules.rules(), ),
                    effective_updated_at = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), ),
                        training=runai.models.training_policy_v2.TrainingPolicyV2(
                    meta = null,
                    policy = runai.models.training_policy_defaults_and_rules_v2.TrainingPolicyDefaultsAndRulesV2(
                        defaults = runai.models.training_policy_defaults_and_rules_v2_defaults.TrainingPolicyDefaultsAndRulesV2_defaults(),
                        rules = runai.models.rules.rules(),
                        imposed_assets = [
                            ''
                            ],
                        status = runai.models.policy_validation_status.PolicyValidationStatus(
                            validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                                error_message = '', ), ), ),
                    effective = runai.models.training_policy_defaults_and_rules_v2.TrainingPolicyDefaultsAndRulesV2(
                        rules = runai.models.rules.rules(), ),
                    effective_updated_at = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), ),
                        distributed=runai.models.distributed_policy_v2.DistributedPolicyV2(
                    meta = null,
                    policy = runai.models.distributed_policy_defaults_and_rules_v2.DistributedPolicyDefaultsAndRulesV2(
                        defaults = runai.models.distributed_policy_defaults_v2.DistributedPolicyDefaultsV2(
                            worker = runai.models.distributed_policy_defaults_v2_worker.DistributedPolicyDefaultsV2_worker(),
                            master = runai.models.replica_defaults_v2.ReplicaDefaultsV2(), ),
                        rules = runai.models.distributed_policy_rules_v2.DistributedPolicyRulesV2(),
                        imposed_assets = runai.models.distributed_imposed_assets.DistributedImposedAssets(),
                        status = runai.models.policy_validation_status.PolicyValidationStatus(
                            validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                                error_message = '', ), ), ),
                    effective = runai.models.distributed_policy_defaults_and_rules_v2.DistributedPolicyDefaultsAndRulesV2(),
                    effective_updated_at = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), ),
                        inference=runai.models.inference_policy_v2.InferencePolicyV2(
                    meta = null,
                    policy = runai.models.inference_policy_defaults_and_rules_v2.InferencePolicyDefaultsAndRulesV2(
                        defaults = runai.models.inference_policy_defaults_and_rules_v2_defaults.InferencePolicyDefaultsAndRulesV2_defaults(),
                        rules = runai.models.rules.rules(),
                        imposed_assets = [
                            ''
                            ],
                        status = runai.models.policy_validation_status.PolicyValidationStatus(
                            validation = runai.models.policy_validation_status_validation.PolicyValidationStatus_validation(
                                error_message = '', ), ), ),
                    effective = runai.models.inference_policy_defaults_and_rules_v2.InferencePolicyDefaultsAndRulesV2(
                        rules = runai.models.rules.rules(), ),
                    effective_updated_at = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), )
        )
        ```
    """  # noqa: E501

    workspace: Optional[WorkspacePolicyV2] = None
    training: Optional[TrainingPolicyV2] = None
    distributed: Optional[DistributedPolicyV2] = None
    inference: Optional[InferencePolicyV2] = None
    __properties: ClassVar[List[str]] = [
        "workspace",
        "training",
        "distributed",
        "inference",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PolicyCrossType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict["workspace"] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of training
        if self.training:
            _dict["training"] = self.training.to_dict()
        # override the default output from pydantic by calling `to_dict()` of distributed
        if self.distributed:
            _dict["distributed"] = self.distributed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inference
        if self.inference:
            _dict["inference"] = self.inference.to_dict()
        # set to None if workspace (nullable) is None
        # and model_fields_set contains the field
        if self.workspace is None and "workspace" in self.model_fields_set:
            _dict["workspace"] = None

        # set to None if training (nullable) is None
        # and model_fields_set contains the field
        if self.training is None and "training" in self.model_fields_set:
            _dict["training"] = None

        # set to None if distributed (nullable) is None
        # and model_fields_set contains the field
        if self.distributed is None and "distributed" in self.model_fields_set:
            _dict["distributed"] = None

        # set to None if inference (nullable) is None
        # and model_fields_set contains the field
        if self.inference is None and "inference" in self.model_fields_set:
            _dict["inference"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PolicyCrossType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "workspace": (
                    WorkspacePolicyV2.from_dict(obj["workspace"])
                    if obj.get("workspace") is not None
                    else None
                ),
                "training": (
                    TrainingPolicyV2.from_dict(obj["training"])
                    if obj.get("training") is not None
                    else None
                ),
                "distributed": (
                    DistributedPolicyV2.from_dict(obj["distributed"])
                    if obj.get("distributed") is not None
                    else None
                ),
                "inference": (
                    InferencePolicyV2.from_dict(obj["inference"])
                    if obj.get("inference") is not None
                    else None
                ),
            }
        )
        return _obj
