# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.integer_rules import IntegerRules
from runai.models.probe_handler_rules import ProbeHandlerRules
from typing import Optional, Set
from typing_extensions import Self


class ProbeRules(BaseModel):
    """
    Pydantic class model representing ProbeRules.

    Parameters:
        ```python
        initial_delay_seconds: Optional[IntegerRules]
        period_seconds: Optional[IntegerRules]
        timeout_seconds: Optional[IntegerRules]
        success_threshold: Optional[IntegerRules]
        failure_threshold: Optional[IntegerRules]
        handler: Optional[ProbeHandlerRules]
        ```
        initial_delay_seconds: See model IntegerRules for more information.
        period_seconds: See model IntegerRules for more information.
        timeout_seconds: See model IntegerRules for more information.
        success_threshold: See model IntegerRules for more information.
        failure_threshold: See model IntegerRules for more information.
        handler: See model ProbeHandlerRules for more information.
    Example:
        ```python
        ProbeRules(
            initial_delay_seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        period_seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        timeout_seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        success_threshold=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        failure_threshold=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        handler=runai.models.probe_handler_rules.ProbeHandlerRules(
                    http_get = runai.models.probe_handler_rules_http_get.ProbeHandlerRules_httpGet(
                        path = runai.models.string_rules.StringRules(),
                        port = runai.models.integer_rules.IntegerRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True,
                            min = 56,
                            max = 56,
                            step = 56,
                            default_from = runai.models.default_from_rule.DefaultFromRule(
                                field = '',
                                factor = 1.337, ), ),
                        host = runai.models.string_rules.StringRules(),
                        scheme = runai.models.string_rules.StringRules(), ), )
        )
        ```
    """  # noqa: E501

    initial_delay_seconds: Optional[IntegerRules] = Field(
        default=None, alias="initialDelaySeconds"
    )
    period_seconds: Optional[IntegerRules] = Field(default=None, alias="periodSeconds")
    timeout_seconds: Optional[IntegerRules] = Field(
        default=None, alias="timeoutSeconds"
    )
    success_threshold: Optional[IntegerRules] = Field(
        default=None, alias="successThreshold"
    )
    failure_threshold: Optional[IntegerRules] = Field(
        default=None, alias="failureThreshold"
    )
    handler: Optional[ProbeHandlerRules] = None
    __properties: ClassVar[List[str]] = [
        "initialDelaySeconds",
        "periodSeconds",
        "timeoutSeconds",
        "successThreshold",
        "failureThreshold",
        "handler",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProbeRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_delay_seconds
        if self.initial_delay_seconds:
            _dict["initialDelaySeconds"] = self.initial_delay_seconds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period_seconds
        if self.period_seconds:
            _dict["periodSeconds"] = self.period_seconds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of timeout_seconds
        if self.timeout_seconds:
            _dict["timeoutSeconds"] = self.timeout_seconds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of success_threshold
        if self.success_threshold:
            _dict["successThreshold"] = self.success_threshold.to_dict()
        # override the default output from pydantic by calling `to_dict()` of failure_threshold
        if self.failure_threshold:
            _dict["failureThreshold"] = self.failure_threshold.to_dict()
        # override the default output from pydantic by calling `to_dict()` of handler
        if self.handler:
            _dict["handler"] = self.handler.to_dict()
        # set to None if initial_delay_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.initial_delay_seconds is None
            and "initial_delay_seconds" in self.model_fields_set
        ):
            _dict["initialDelaySeconds"] = None

        # set to None if period_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.period_seconds is None and "period_seconds" in self.model_fields_set:
            _dict["periodSeconds"] = None

        # set to None if timeout_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.timeout_seconds is None and "timeout_seconds" in self.model_fields_set:
            _dict["timeoutSeconds"] = None

        # set to None if success_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.success_threshold is None
            and "success_threshold" in self.model_fields_set
        ):
            _dict["successThreshold"] = None

        # set to None if failure_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.failure_threshold is None
            and "failure_threshold" in self.model_fields_set
        ):
            _dict["failureThreshold"] = None

        # set to None if handler (nullable) is None
        # and model_fields_set contains the field
        if self.handler is None and "handler" in self.model_fields_set:
            _dict["handler"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProbeRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "initialDelaySeconds": (
                    IntegerRules.from_dict(obj["initialDelaySeconds"])
                    if obj.get("initialDelaySeconds") is not None
                    else None
                ),
                "periodSeconds": (
                    IntegerRules.from_dict(obj["periodSeconds"])
                    if obj.get("periodSeconds") is not None
                    else None
                ),
                "timeoutSeconds": (
                    IntegerRules.from_dict(obj["timeoutSeconds"])
                    if obj.get("timeoutSeconds") is not None
                    else None
                ),
                "successThreshold": (
                    IntegerRules.from_dict(obj["successThreshold"])
                    if obj.get("successThreshold") is not None
                    else None
                ),
                "failureThreshold": (
                    IntegerRules.from_dict(obj["failureThreshold"])
                    if obj.get("failureThreshold") is not None
                    else None
                ),
                "handler": (
                    ProbeHandlerRules.from_dict(obj["handler"])
                    if obj.get("handler") is not None
                    else None
                ),
            }
        )
        return _obj
