# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.project_phase import ProjectPhase
from runai.models.quota_status import QuotaStatus
from runai.models.quota_status_node_pool import QuotaStatusNodePool
from typing import Optional, Set
from typing_extensions import Self


class ProjectStatus(BaseModel):
    """
    Pydantic class model representing ProjectStatus.

    Parameters:
        ```python
        namespace: Optional[str]
        phase: ProjectPhase
        phase_message: Optional[str]
        last_updated_time: Optional[datetime]
        node_pool_quota_statuses: List[QuotaStatusNodePool]
        quota_status: QuotaStatus
        additional_status_data: Optional[Dict[str, object]]
        ```
        namespace: the project&#39;s namespace
        phase: See model ProjectPhase for more information.
        phase_message: the project&#39;s phase message
        last_updated_time: See model datetime for more information.
        node_pool_quota_statuses: See model List[QuotaStatusNodePool] for more information.
        quota_status: See model QuotaStatus for more information.
        additional_status_data: See model Dict[str, object] for more information.
    Example:
        ```python
        ProjectStatus(
            namespace='runai-proj1',
                        phase='Creating',
                        phase_message='Project is ready',
                        last_updated_time=datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                        node_pool_quota_statuses=[
                    null
                    ],
                        quota_status=runai.models.quota_status.QuotaStatus(
                    allocated = runai.models.quota_status_resource.QuotaStatusResource(
                        gpu = 0,
                        cpu = 1000,
                        memory = 1000, ),
                    allocated_non_preemptible = runai.models.quota_status_resource.QuotaStatusResource(
                        gpu = 0,
                        cpu = 1000,
                        memory = 1000, ),
                    requested = , ),
                        additional_status_data={ }
        )
        ```
    """  # noqa: E501

    namespace: Optional[StrictStr] = Field(
        default=None, description="the project's namespace"
    )
    phase: Optional[ProjectPhase] = None
    phase_message: Optional[StrictStr] = Field(
        default=None, description="the project's phase message", alias="phaseMessage"
    )
    last_updated_time: Optional[datetime] = Field(default=None, alias="lastUpdatedTime")
    node_pool_quota_statuses: Optional[List[QuotaStatusNodePool]] = Field(
        default=None, alias="nodePoolQuotaStatuses"
    )
    quota_status: Optional[QuotaStatus] = Field(default=None, alias="quotaStatus")
    additional_status_data: Optional[Dict[str, Any]] = Field(
        default=None, alias="additionalStatusData"
    )
    __properties: ClassVar[List[str]] = [
        "namespace",
        "phase",
        "phaseMessage",
        "lastUpdatedTime",
        "nodePoolQuotaStatuses",
        "quotaStatus",
        "additionalStatusData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in node_pool_quota_statuses (list)
        _items = []
        if self.node_pool_quota_statuses:
            for _item_node_pool_quota_statuses in self.node_pool_quota_statuses:
                if _item_node_pool_quota_statuses:
                    _items.append(_item_node_pool_quota_statuses.to_dict())
            _dict["nodePoolQuotaStatuses"] = _items
        # override the default output from pydantic by calling `to_dict()` of quota_status
        if self.quota_status:
            _dict["quotaStatus"] = self.quota_status.to_dict()
        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict["namespace"] = None

        # set to None if phase_message (nullable) is None
        # and model_fields_set contains the field
        if self.phase_message is None and "phase_message" in self.model_fields_set:
            _dict["phaseMessage"] = None

        # set to None if last_updated_time (nullable) is None
        # and model_fields_set contains the field
        if (
            self.last_updated_time is None
            and "last_updated_time" in self.model_fields_set
        ):
            _dict["lastUpdatedTime"] = None

        # set to None if additional_status_data (nullable) is None
        # and model_fields_set contains the field
        if (
            self.additional_status_data is None
            and "additional_status_data" in self.model_fields_set
        ):
            _dict["additionalStatusData"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "namespace": obj.get("namespace"),
                "phase": obj.get("phase"),
                "phaseMessage": obj.get("phaseMessage"),
                "lastUpdatedTime": obj.get("lastUpdatedTime"),
                "nodePoolQuotaStatuses": (
                    [
                        QuotaStatusNodePool.from_dict(_item)
                        for _item in obj["nodePoolQuotaStatuses"]
                    ]
                    if obj.get("nodePoolQuotaStatuses") is not None
                    else None
                ),
                "quotaStatus": (
                    QuotaStatus.from_dict(obj["quotaStatus"])
                    if obj.get("quotaStatus") is not None
                    else None
                ),
                "additionalStatusData": obj.get("additionalStatusData"),
            }
        )
        return _obj
