# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.quota_status_v1_inner import QuotaStatusV1Inner
from typing import Optional, Set
from typing_extensions import Self


class ProjectV1AllOfStatus(BaseModel):
    """
    Pydantic class model representing ProjectV1AllOfStatus.

    Parameters:
        ```python
        namespace: str
        message: str
        phase: str
        conditions: List[Dict[str, str]]
        quota_statuses: List[QuotaStatusV1Inner]
        ```
        namespace: The namespace of the project
        message: Detailed phase message
        phase: project&#39;s phase
        conditions: See model List[Dict[str, str]] for more information.
        quota_statuses: The current quota status for each node pool. Supported only for cluster versions 2.15+ or higher.
    Example:
        ```python
        ProjectV1AllOfStatus(
            namespace='runai-team-a',
                        message='NamespaceHandlerFailed',
                        phase='Ready',
                        conditions=[
                    {
                        'key' : ''
                        }
                    ],
                        quota_statuses=[
                    runai.models.quota_status_v1_inner.QuotaStatusV1_inner(
                        node_pool_name = '',
                        allocated = runai.models.quota_status_resource_list_v1.QuotaStatusResourceListV1(
                            gpu = 0,
                            cpu = 1000,
                            memory = 1000, ),
                        allocated_non_preemptible = runai.models.quota_status_resource_list_v1.QuotaStatusResourceListV1(
                            gpu = 0,
                            cpu = 1000,
                            memory = 1000, ),
                        requested = , )
                    ]
        )
        ```
    """  # noqa: E501

    namespace: Optional[StrictStr] = Field(
        default=None, description="The namespace of the project"
    )
    message: Optional[StrictStr] = Field(
        default=None, description="Detailed phase message"
    )
    phase: Optional[StrictStr] = Field(default=None, description="project's phase")
    conditions: Optional[List[Dict[str, StrictStr]]] = None
    quota_statuses: List[QuotaStatusV1Inner] = Field(
        description="The current quota status for each node pool. Supported only for cluster versions 2.15+ or higher.",
        alias="quotaStatuses",
    )
    __properties: ClassVar[List[str]] = [
        "namespace",
        "message",
        "phase",
        "conditions",
        "quotaStatuses",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectV1AllOfStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in quota_statuses (list)
        _items = []
        if self.quota_statuses:
            for _item_quota_statuses in self.quota_statuses:
                if _item_quota_statuses:
                    _items.append(_item_quota_statuses.to_dict())
            _dict["quotaStatuses"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectV1AllOfStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "namespace": obj.get("namespace"),
                "message": obj.get("message"),
                "phase": obj.get("phase"),
                "conditions": obj.get("conditions"),
                "quotaStatuses": (
                    [
                        QuotaStatusV1Inner.from_dict(_item)
                        for _item in obj["quotaStatuses"]
                    ]
                    if obj.get("quotaStatuses") is not None
                    else None
                ),
            }
        )
        return _obj
