# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from runai.models.pvc_added_attribute_format import PvcAddedAttributeFormat
from typing import Optional, Set
from typing_extensions import Self


class PvcAddedAttribute(BaseModel):
    """
    Pydantic class model representing Attribute that is added to any PVC of a given storage class..

    Parameters:
        ```python
        key: str
        format: Optional[PvcAddedAttributeFormat]
        display: Optional[str]
        description: Optional[str]
        placeholder: Optional[str]
        required: Optional[bool]
        default_value: Optional[str]
        validation_regexp: Optional[str]
        min_value: Optional[float]
        max_value: Optional[float]
        step: Optional[float]
        validation_error: Optional[str]
        ```
        key: the PVC annotation to receive the value of this attribute. must be aligned with the rules of a name part of an annotation key, i.e. required, 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
        format: See model PvcAddedAttributeFormat for more information.
        display: a user friendly name describing the attribute
        description: textual explanation of the attribute
        placeholder: hint for the value that the attribute can hold. can be used as watermark in frontend fields or in help messages
        required: whether the attribute is mandatory
        default_value: the default value for the attribute
        validation_regexp: for text format, optional regex to validate the provided text
        min_value: for number format, optional minimum value that can be provided
        max_value: for number format, optional maximum value that can be provided
        step: for number format, required gap between permitted value
        validation_error: optional text for validation error. if not provided, default error text will be composed.
    Example:
        ```python
        PvcAddedAttribute(
            key='dnsname',
                        format='text',
                        display='DNS Name',
                        description='The host name of the DNS',
                        placeholder='enter hostname or IP address',
                        required=True,
                        default_value='my.dns.com',
                        validation_regexp='^[a-zA-Z0-9.-_]+$',
                        min_value=100,
                        max_value=200,
                        step=5,
                        validation_error='Invalid URL'
        )
        ```
    """  # noqa: E501

    key: Annotated[str, Field(min_length=1, strict=True, max_length=63)] = Field(
        description="the PVC annotation to receive the value of this attribute. must be aligned with the rules of a name part of an annotation key, i.e. required, 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between."
    )
    format: Optional[PvcAddedAttributeFormat] = None
    display: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="a user friendly name describing the attribute"
    )
    description: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="textual explanation of the attribute"
    )
    placeholder: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="hint for the value that the attribute can hold. can be used as watermark in frontend fields or in help messages",
    )
    required: Optional[StrictBool] = Field(
        default=None, description="whether the attribute is mandatory"
    )
    default_value: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="the default value for the attribute",
        alias="defaultValue",
    )
    validation_regexp: Optional[Annotated[str, Field(min_length=1, strict=True)]] = (
        Field(
            default=None,
            description="for text format, optional regex to validate the provided text",
            alias="validationRegexp",
        )
    )
    min_value: Optional[
        Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]
    ] = Field(
        default=None,
        description="for number format, optional minimum value that can be provided",
        alias="minValue",
    )
    max_value: Optional[
        Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]
    ] = Field(
        default=None,
        description="for number format, optional maximum value that can be provided",
        alias="maxValue",
    )
    step: Optional[
        Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]
    ] = Field(
        default=None,
        description="for number format, required gap between permitted value",
    )
    validation_error: Optional[Annotated[str, Field(min_length=1, strict=True)]] = (
        Field(
            default=None,
            description="optional text for validation error. if not provided, default error text will be composed.",
            alias="validationError",
        )
    )
    __properties: ClassVar[List[str]] = [
        "key",
        "format",
        "display",
        "description",
        "placeholder",
        "required",
        "defaultValue",
        "validationRegexp",
        "minValue",
        "maxValue",
        "step",
        "validationError",
    ]

    @field_validator("key")
    def key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]$", value):
            raise ValueError(
                r"must validate the regular expression /^([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PvcAddedAttribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if format (nullable) is None
        # and model_fields_set contains the field
        if self.format is None and "format" in self.model_fields_set:
            _dict["format"] = None

        # set to None if display (nullable) is None
        # and model_fields_set contains the field
        if self.display is None and "display" in self.model_fields_set:
            _dict["display"] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        # set to None if placeholder (nullable) is None
        # and model_fields_set contains the field
        if self.placeholder is None and "placeholder" in self.model_fields_set:
            _dict["placeholder"] = None

        # set to None if required (nullable) is None
        # and model_fields_set contains the field
        if self.required is None and "required" in self.model_fields_set:
            _dict["required"] = None

        # set to None if default_value (nullable) is None
        # and model_fields_set contains the field
        if self.default_value is None and "default_value" in self.model_fields_set:
            _dict["defaultValue"] = None

        # set to None if validation_regexp (nullable) is None
        # and model_fields_set contains the field
        if (
            self.validation_regexp is None
            and "validation_regexp" in self.model_fields_set
        ):
            _dict["validationRegexp"] = None

        # set to None if min_value (nullable) is None
        # and model_fields_set contains the field
        if self.min_value is None and "min_value" in self.model_fields_set:
            _dict["minValue"] = None

        # set to None if max_value (nullable) is None
        # and model_fields_set contains the field
        if self.max_value is None and "max_value" in self.model_fields_set:
            _dict["maxValue"] = None

        # set to None if step (nullable) is None
        # and model_fields_set contains the field
        if self.step is None and "step" in self.model_fields_set:
            _dict["step"] = None

        # set to None if validation_error (nullable) is None
        # and model_fields_set contains the field
        if (
            self.validation_error is None
            and "validation_error" in self.model_fields_set
        ):
            _dict["validationError"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PvcAddedAttribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "key": obj.get("key"),
                "format": obj.get("format"),
                "display": obj.get("display"),
                "description": obj.get("description"),
                "placeholder": obj.get("placeholder"),
                "required": obj.get("required"),
                "defaultValue": obj.get("defaultValue"),
                "validationRegexp": obj.get("validationRegexp"),
                "minValue": obj.get("minValue"),
                "maxValue": obj.get("maxValue"),
                "step": obj.get("step"),
                "validationError": obj.get("validationError"),
            }
        )
        return _obj
