# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.boolean_rules import BooleanRules
from runai.models.claim_info_rules import ClaimInfoRules
from runai.models.string_rules import StringRules
from typing import Optional, Set
from typing_extensions import Self


class PvcRules(BaseModel):
    """
    Pydantic class model representing PvcRules.

    Parameters:
        ```python
        claim_name: Optional[StringRules]
        path: Optional[StringRules]
        read_only: Optional[BooleanRules]
        claim_info: Optional[ClaimInfoRules]
        ```
        claim_name: See model StringRules for more information.
        path: See model StringRules for more information.
        read_only: See model BooleanRules for more information.
        claim_info: See model ClaimInfoRules for more information.
    Example:
        ```python
        PvcRules(
            claim_name=runai.models.string_rules.StringRules(),
                        path=runai.models.string_rules.StringRules(),
                        read_only=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        claim_info=runai.models.claim_info_rules.ClaimInfoRules(
                    size = runai.models.string_rules.StringRules(),
                    storage_class = runai.models.string_rules.StringRules(),
                    access_modes = runai.models.pvc_access_modes_rules.PvcAccessModesRules(
                        read_write_once = runai.models.boolean_rules.BooleanRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True, ),
                        read_only_many = runai.models.boolean_rules.BooleanRules(
                            required = True,
                            can_edit = True, ),
                        read_write_many = , ), )
        )
        ```
    """  # noqa: E501

    claim_name: Optional[StringRules] = Field(default=None, alias="claimName")
    path: Optional[StringRules] = None
    read_only: Optional[BooleanRules] = Field(default=None, alias="readOnly")
    claim_info: Optional[ClaimInfoRules] = Field(default=None, alias="claimInfo")
    __properties: ClassVar[List[str]] = ["claimName", "path", "readOnly", "claimInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PvcRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of claim_name
        if self.claim_name:
            _dict["claimName"] = self.claim_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of path
        if self.path:
            _dict["path"] = self.path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of read_only
        if self.read_only:
            _dict["readOnly"] = self.read_only.to_dict()
        # override the default output from pydantic by calling `to_dict()` of claim_info
        if self.claim_info:
            _dict["claimInfo"] = self.claim_info.to_dict()
        # set to None if claim_name (nullable) is None
        # and model_fields_set contains the field
        if self.claim_name is None and "claim_name" in self.model_fields_set:
            _dict["claimName"] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict["path"] = None

        # set to None if read_only (nullable) is None
        # and model_fields_set contains the field
        if self.read_only is None and "read_only" in self.model_fields_set:
            _dict["readOnly"] = None

        # set to None if claim_info (nullable) is None
        # and model_fields_set contains the field
        if self.claim_info is None and "claim_info" in self.model_fields_set:
            _dict["claimInfo"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PvcRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "claimName": (
                    StringRules.from_dict(obj["claimName"])
                    if obj.get("claimName") is not None
                    else None
                ),
                "path": (
                    StringRules.from_dict(obj["path"])
                    if obj.get("path") is not None
                    else None
                ),
                "readOnly": (
                    BooleanRules.from_dict(obj["readOnly"])
                    if obj.get("readOnly") is not None
                    else None
                ),
                "claimInfo": (
                    ClaimInfoRules.from_dict(obj["claimInfo"])
                    if obj.get("claimInfo") is not None
                    else None
                ),
            }
        )
        return _obj
