# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.quota_status_resource_list_v1 import QuotaStatusResourceListV1
from typing import Optional, Set
from typing_extensions import Self


class QuotaStatusV1Inner(BaseModel):
    """
    Pydantic class model representing QuotaStatusV1Inner.

    Parameters:
        ```python
        node_pool_name: str
        allocated: QuotaStatusResourceListV1
        allocated_non_preemptible: QuotaStatusResourceListV1
        requested: QuotaStatusResourceListV1
        ```
        node_pool_name: The node pool name which the current quota status refers to.
        allocated: See model QuotaStatusResourceListV1 for more information.
        allocated_non_preemptible: See model QuotaStatusResourceListV1 for more information.
        requested: See model QuotaStatusResourceListV1 for more information.
    Example:
        ```python
        QuotaStatusV1Inner(
            node_pool_name='',
                        allocated=runai.models.quota_status_resource_list_v1.QuotaStatusResourceListV1(
                    gpu = 0,
                    cpu = 1000,
                    memory = 1000, ),
                        allocated_non_preemptible=runai.models.quota_status_resource_list_v1.QuotaStatusResourceListV1(
                    gpu = 0,
                    cpu = 1000,
                    memory = 1000, ),
                        requested=runai.models.quota_status_resource_list_v1.QuotaStatusResourceListV1(
                    gpu = 0,
                    cpu = 1000,
                    memory = 1000, )
        )
        ```
    """  # noqa: E501

    node_pool_name: Optional[StrictStr] = Field(
        default=None,
        description="The node pool name which the current quota status refers to.",
        alias="nodePoolName",
    )
    allocated: Optional[QuotaStatusResourceListV1] = None
    allocated_non_preemptible: Optional[QuotaStatusResourceListV1] = Field(
        default=None, alias="allocatedNonPreemptible"
    )
    requested: Optional[QuotaStatusResourceListV1] = None
    __properties: ClassVar[List[str]] = [
        "nodePoolName",
        "allocated",
        "allocatedNonPreemptible",
        "requested",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QuotaStatusV1Inner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of allocated
        if self.allocated:
            _dict["allocated"] = self.allocated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allocated_non_preemptible
        if self.allocated_non_preemptible:
            _dict["allocatedNonPreemptible"] = self.allocated_non_preemptible.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested
        if self.requested:
            _dict["requested"] = self.requested.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QuotaStatusV1Inner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "nodePoolName": obj.get("nodePoolName"),
                "allocated": (
                    QuotaStatusResourceListV1.from_dict(obj["allocated"])
                    if obj.get("allocated") is not None
                    else None
                ),
                "allocatedNonPreemptible": (
                    QuotaStatusResourceListV1.from_dict(obj["allocatedNonPreemptible"])
                    if obj.get("allocatedNonPreemptible") is not None
                    else None
                ),
                "requested": (
                    QuotaStatusResourceListV1.from_dict(obj["requested"])
                    if obj.get("requested") is not None
                    else None
                ),
            }
        )
        return _obj
