# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.label1 import Label1
from runai.models.metric_information_for_report import MetricInformationForReport
from runai.models.range import Range
from typing import Optional, Set
from typing_extensions import Self


class ReportRequestFields1(BaseModel):
    """
    Pydantic class model representing ReportRequestFields1.

    Parameters:
        ```python
        name: str
        description: str
        labels: List[Label1]
        range: Optional[Range]
        additional_fields: Dict[str, object]
        metrics: List[MetricInformationForReport]
        ```
        name: See model str for more information.
        description: See model str for more information.
        labels: See model List[Label1] for more information.
        range: See model Range for more information.
        additional_fields: See model Dict[str, object] for more information.
        metrics: See model List[MetricInformationForReport] for more information.
    Example:
        ```python
        ReportRequestFields1(
            name='2023 GPU report',
                        description='This report shows the GPU usage of all projects in the organization',
                        labels=[
                    runai.models.label1.Label1(
                        name = 'nodepoolName',
                        display_name = 'Node pool', )
                    ],
                        range=runai.models.range.Range(
                    start = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'),
                    end = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), ),
                        additional_fields={ },
                        metrics=[
                    runai.models.metric_information_for_report.MetricInformationForReport(
                        name = 'gpu_allocation_hours',
                        display_name = 'GPU allocation hours',
                        filters = {
                            'key' : [
                                ''
                                ]
                            },
                        quantile = 0.5, )
                    ]
        )
        ```
    """  # noqa: E501

    name: StrictStr
    description: Optional[StrictStr] = None
    labels: Optional[List[Label1]] = None
    range: Optional[Range]
    additional_fields: Optional[Dict[str, Any]] = Field(
        default=None, alias="additionalFields"
    )
    metrics: List[MetricInformationForReport]
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "labels",
        "range",
        "additionalFields",
        "metrics",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportRequestFields1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict["labels"] = _items
        # override the default output from pydantic by calling `to_dict()` of range
        if self.range:
            _dict["range"] = self.range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in metrics (list)
        _items = []
        if self.metrics:
            for _item_metrics in self.metrics:
                if _item_metrics:
                    _items.append(_item_metrics.to_dict())
            _dict["metrics"] = _items
        # set to None if range (nullable) is None
        # and model_fields_set contains the field
        if self.range is None and "range" in self.model_fields_set:
            _dict["range"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportRequestFields1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "labels": (
                    [Label1.from_dict(_item) for _item in obj["labels"]]
                    if obj.get("labels") is not None
                    else None
                ),
                "range": (
                    Range.from_dict(obj["range"])
                    if obj.get("range") is not None
                    else None
                ),
                "additionalFields": obj.get("additionalFields"),
                "metrics": (
                    [
                        MetricInformationForReport.from_dict(_item)
                        for _item in obj["metrics"]
                    ]
                    if obj.get("metrics") is not None
                    else None
                ),
            }
        )
        return _obj
