# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class RequestedPods(BaseModel):
    """
    Pydantic class model representing RequestedPods.

    Parameters:
        ```python
        number: Optional[int]
        min: Optional[int]
        max: Optional[int]
        parallelism: Optional[int]
        completions: Optional[int]
        ```
        number: See model int for more information.
        min: See model int for more information.
        max: See model int for more information.
        parallelism: specifies how many Pods can run in parallel
        completions: specifies how many Pods should terminate successfully before the Workload is completed
    Example:
        ```python
        RequestedPods(
            number=1,
                        min=2,
                        max=5,
                        parallelism=3,
                        completions=5
        )
        ```
    """  # noqa: E501

    number: Optional[StrictInt] = None
    min: Optional[StrictInt] = None
    max: Optional[StrictInt] = None
    parallelism: Optional[StrictInt] = Field(
        default=None, description="specifies how many Pods can run in parallel"
    )
    completions: Optional[StrictInt] = Field(
        default=None,
        description="specifies how many Pods should terminate successfully before the Workload is completed",
    )
    __properties: ClassVar[List[str]] = [
        "number",
        "min",
        "max",
        "parallelism",
        "completions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RequestedPods from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if number (nullable) is None
        # and model_fields_set contains the field
        if self.number is None and "number" in self.model_fields_set:
            _dict["number"] = None

        # set to None if min (nullable) is None
        # and model_fields_set contains the field
        if self.min is None and "min" in self.model_fields_set:
            _dict["min"] = None

        # set to None if max (nullable) is None
        # and model_fields_set contains the field
        if self.max is None and "max" in self.model_fields_set:
            _dict["max"] = None

        # set to None if parallelism (nullable) is None
        # and model_fields_set contains the field
        if self.parallelism is None and "parallelism" in self.model_fields_set:
            _dict["parallelism"] = None

        # set to None if completions (nullable) is None
        # and model_fields_set contains the field
        if self.completions is None and "completions" in self.model_fields_set:
            _dict["completions"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RequestedPods from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "number": obj.get("number"),
                "min": obj.get("min"),
                "max": obj.get("max"),
                "parallelism": obj.get("parallelism"),
                "completions": obj.get("completions"),
            }
        )
        return _obj
