# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class ResourceType(str, Enum):
    """
    ResourceType

    Allowed enum values:

    DEPARTMENT = 'department'

    TENANT = 'tenant'

    PROJECT = 'project'

    CLUSTER = 'cluster'

    CLUSTER_MINUS_CONFIG = 'cluster-config'

    NODEPOOLS = 'nodepools'

    NODES = 'nodes'

    SETTINGS = 'settings'

    SECURITY_MINUS_SETTINGS = 'security-settings'

    USERS = 'users'

    GROUPS = 'groups'

    APPS = 'apps'

    DASHBOARDS_MINUS_OVERVIEW = 'dashboards-overview'

    DASHBOARDS_MINUS_ANALYTICS = 'dashboards-analytics'

    DASHBOARDS_MINUS_CONSUMPTION = 'dashboards-consumption'

    ROLES = 'roles'

    ACCESS_RULES = 'access_rules'

    JOBS = 'jobs'

    WORKLOADS = 'workloads'

    WORKSPACES = 'workspaces'

    TRAININGS = 'trainings'

    INFERENCES = 'inferences'

    ENVIRONMENTS = 'environments'

    PVC_MINUS_ASSETS = 'pvc-assets'

    GIT_MINUS_ASSETS = 'git-assets'

    HOST_MINUS_PATH_MINUS_ASSETS = 'host-path-assets'

    NFS_MINUS_ASSETS = 'nfs-assets'

    S3_MINUS_ASSETS = 's3-assets'

    COMPUTE_MINUS_RESOURCES = 'compute-resources'

    TEMPLATES = 'templates'

    CREDENTIALS = 'credentials'

    EVENTS_MINUS_HISTORY = 'events-history'

    POLICIES = 'policies'

    CM_MINUS_VOLUME_MINUS_ASSETS = 'cm-volume-assets'

    DATAVOLUMES = 'datavolumes'

    SECRET_MINUS_VOLUME_MINUS_ASSETS = 'secret-volume-assets'

    STORAGE_MINUS_CLASS_MINUS_CONFIGURATION = 'storage-class-configuration'

    USER_MINUS_APPS = 'user-apps'

    WORKLOAD_MINUS_PROPERTIES = 'workload-properties'


    Example:
        ```python
        ResourceType.DEPARTMENT
        ResourceType.TENANT
        ResourceType.PROJECT
        ResourceType.CLUSTER
        ResourceType.CLUSTER_MINUS_CONFIG
        ResourceType.NODEPOOLS
        ResourceType.NODES
        ResourceType.SETTINGS
        ResourceType.SECURITY_MINUS_SETTINGS
        ResourceType.USERS
        ResourceType.GROUPS
        ResourceType.APPS
        ResourceType.DASHBOARDS_MINUS_OVERVIEW
        ResourceType.DASHBOARDS_MINUS_ANALYTICS
        ResourceType.DASHBOARDS_MINUS_CONSUMPTION
        ResourceType.ROLES
        ResourceType.ACCESS_RULES
        ResourceType.JOBS
        ResourceType.WORKLOADS
        ResourceType.WORKSPACES
        ResourceType.TRAININGS
        ResourceType.INFERENCES
        ResourceType.ENVIRONMENTS
        ResourceType.PVC_MINUS_ASSETS
        ResourceType.GIT_MINUS_ASSETS
        ResourceType.HOST_MINUS_PATH_MINUS_ASSETS
        ResourceType.NFS_MINUS_ASSETS
        ResourceType.S3_MINUS_ASSETS
        ResourceType.COMPUTE_MINUS_RESOURCES
        ResourceType.TEMPLATES
        ResourceType.CREDENTIALS
        ResourceType.EVENTS_MINUS_HISTORY
        ResourceType.POLICIES
        ResourceType.CM_MINUS_VOLUME_MINUS_ASSETS
        ResourceType.DATAVOLUMES
        ResourceType.SECRET_MINUS_VOLUME_MINUS_ASSETS
        ResourceType.STORAGE_MINUS_CLASS_MINUS_CONFIGURATION
        ResourceType.USER_MINUS_APPS
        ResourceType.WORKLOAD_MINUS_PROPERTIES
        ```
    """

    DEPARTMENT = "department"
    TENANT = "tenant"
    PROJECT = "project"
    CLUSTER = "cluster"
    CLUSTER_MINUS_CONFIG = "cluster-config"
    NODEPOOLS = "nodepools"
    NODES = "nodes"
    SETTINGS = "settings"
    SECURITY_MINUS_SETTINGS = "security-settings"
    USERS = "users"
    GROUPS = "groups"
    APPS = "apps"
    DASHBOARDS_MINUS_OVERVIEW = "dashboards-overview"
    DASHBOARDS_MINUS_ANALYTICS = "dashboards-analytics"
    DASHBOARDS_MINUS_CONSUMPTION = "dashboards-consumption"
    ROLES = "roles"
    ACCESS_RULES = "access_rules"
    JOBS = "jobs"
    WORKLOADS = "workloads"
    WORKSPACES = "workspaces"
    TRAININGS = "trainings"
    INFERENCES = "inferences"
    ENVIRONMENTS = "environments"
    PVC_MINUS_ASSETS = "pvc-assets"
    GIT_MINUS_ASSETS = "git-assets"
    HOST_MINUS_PATH_MINUS_ASSETS = "host-path-assets"
    NFS_MINUS_ASSETS = "nfs-assets"
    S3_MINUS_ASSETS = "s3-assets"
    COMPUTE_MINUS_RESOURCES = "compute-resources"
    TEMPLATES = "templates"
    CREDENTIALS = "credentials"
    EVENTS_MINUS_HISTORY = "events-history"
    POLICIES = "policies"
    CM_MINUS_VOLUME_MINUS_ASSETS = "cm-volume-assets"
    DATAVOLUMES = "datavolumes"
    SECRET_MINUS_VOLUME_MINUS_ASSETS = "secret-volume-assets"
    STORAGE_MINUS_CLASS_MINUS_CONFIGURATION = "storage-class-configuration"
    USER_MINUS_APPS = "user-apps"
    WORKLOAD_MINUS_PROPERTIES = "workload-properties"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ResourceType from a JSON string"""
        return cls(json.loads(json_str))
