# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.condition1 import Condition1
from runai.models.phase import Phase
from runai.models.requested_pods import RequestedPods
from runai.models.workload_allocated_resources import WorkloadAllocatedResources
from runai.models.workload_children_ids_inner import WorkloadChildrenIdsInner
from runai.models.workload_request_resources import WorkloadRequestResources
from typing import Optional, Set
from typing_extensions import Self


class Revision(BaseModel):
    """
    Pydantic class model representing Revision.

    Parameters:
        ```python
        type: str
        name: str
        id: str
        workload_id: str
        tenant_id: int
        cluster_id: str
        project_id: str
        department_id: str
        created_at: datetime
        deleted_at: Optional[datetime]
        revision_requested_resources: Optional[WorkloadRequestResources]
        pods_requested_resources: Optional[WorkloadRequestResources]
        requested_pods: RequestedPods
        requested_node_pools: List[str]
        allocated_resources: Optional[WorkloadAllocatedResources]
        current_node_pools: List[str]
        running_pods: int
        images: List[str]
        environment_variables: Dict[str, str]
        command: str
        arguments: str
        children_ids: List[WorkloadChildrenIdsInner]
        conditions: List[Condition1]
        phase: Phase
        phase_message: str
        phase_updated_at: datetime
        additional_fields: Dict[str, object]
        ```
        type: See model str for more information.
        name: See model str for more information.
        id: See model str for more information.
        workload_id: See model str for more information.
        tenant_id: The id of the tenant.
        cluster_id: The id of the cluster.
        project_id: The id of the project.
        department_id: The id of the department.
        created_at: See model datetime for more information.
        deleted_at: See model datetime for more information.
        revision_requested_resources: See model WorkloadRequestResources for more information.
        pods_requested_resources: See model WorkloadRequestResources for more information.
        requested_pods: See model RequestedPods for more information.
        requested_node_pools: See model List[str] for more information.
        allocated_resources: See model WorkloadAllocatedResources for more information.
        current_node_pools: See model List[str] for more information.
        running_pods: See model int for more information.
        images: See model List[str] for more information.
        environment_variables: See model Dict[str, str] for more information.
        command: See model str for more information.
        arguments: See model str for more information.
        children_ids: See model List[WorkloadChildrenIdsInner] for more information.
        conditions: See model List[Condition1] for more information.
        phase: See model Phase for more information.
        phase_message: See model str for more information.
        phase_updated_at: See model datetime for more information.
        additional_fields: See model Dict[str, object] for more information.
    Example:
        ```python
        Revision(
            type='runai-revision',
                        name='very-important-job',
                        id='',
                        workload_id='',
                        tenant_id=1001,
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        project_id='1',
                        department_id='2',
                        created_at='2022-01-01T03:49:52.531Z',
                        deleted_at='2022-08-12T19:28:24.131Z',
                        revision_requested_resources=runai.models.workload_request_resources.WorkloadRequestResources(
                    gpu_request_type = 'portion',
                    gpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    gpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    cpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    cpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    mig_profile = [
                        '1g.5gb'
                        ],
                    extended_resources = [
                        runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                            resource = 'hardware-vendor.example/foo',
                            quantity = '2',
                            exclude = False, )
                        ], ),
                        pods_requested_resources=runai.models.workload_request_resources.WorkloadRequestResources(
                    gpu_request_type = 'portion',
                    gpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    gpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    cpu = runai.models.request_resource_cores.RequestResourceCores(
                        limit = 1.5,
                        request = 1, ),
                    cpu_memory = runai.models.request_resource_quantity.RequestResourceQuantity(
                        limit = '2G',
                        request = '200M', ),
                    mig_profile = [
                        '1g.5gb'
                        ],
                    extended_resources = [
                        runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                            resource = 'hardware-vendor.example/foo',
                            quantity = '2',
                            exclude = False, )
                        ], ),
                        requested_pods=runai.models.requested_pods.RequestedPods(
                    number = 1,
                    min = 2,
                    max = 5,
                    parallelism = 3,
                    completions = 5, ),
                        requested_node_pools=[
                    'default'
                    ],
                        allocated_resources=runai.models.workload_allocated_resources.WorkloadAllocatedResources(
                    gpu = 1.5,
                    mig_profile = [
                        '1g.5gb'
                        ],
                    gpu_memory = '200Mi',
                    cpu = 0.5,
                    cpu_memory = '0B',
                    extended_resources = [
                        runai.models.workloads_extended_resource.WorkloadsExtendedResource(
                            resource = 'hardware-vendor.example/foo',
                            quantity = '2',
                            exclude = False, )
                        ], ),
                        current_node_pools=[
                    'default'
                    ],
                        running_pods=1,
                        images=[
                    'alpine:latest'
                    ],
                        environment_variables={
                    'key' : ''
                    },
                        command='sleep',
                        arguments='1000',
                        children_ids=[
                    runai.models.workload_children_ids_inner.Workload_childrenIds_inner(
                        id = '',
                        type = '', )
                    ],
                        conditions=[
                    runai.models.condition1.Condition1(
                        type = 'Ready',
                        status = 'False',
                        message = 'Resource validation failed: ...',
                        reason = 'ErrorConfig',
                        last_transition_time = '2022-01-01T03:49:52.531Z', )
                    ],
                        phase='Creating',
                        phase_message='Not enough resources in the requested nodepool',
                        phase_updated_at='2022-06-08T11:28:24.131Z',
                        additional_fields={ }
        )
        ```
    """  # noqa: E501

    type: StrictStr
    name: StrictStr
    id: StrictStr
    workload_id: StrictStr = Field(alias="workloadId")
    tenant_id: StrictInt = Field(description="The id of the tenant.", alias="tenantId")
    cluster_id: StrictStr = Field(
        description="The id of the cluster.", alias="clusterId"
    )
    project_id: StrictStr = Field(
        description="The id of the project.", alias="projectId"
    )
    department_id: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="The id of the department.", alias="departmentId"
    )
    created_at: datetime = Field(alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    revision_requested_resources: Optional[WorkloadRequestResources] = Field(
        default=None, alias="revisionRequestedResources"
    )
    pods_requested_resources: Optional[WorkloadRequestResources] = Field(
        default=None, alias="podsRequestedResources"
    )
    requested_pods: Optional[RequestedPods] = Field(default=None, alias="requestedPods")
    requested_node_pools: Optional[List[StrictStr]] = Field(
        default=None, alias="requestedNodePools"
    )
    allocated_resources: Optional[WorkloadAllocatedResources] = Field(
        default=None, alias="allocatedResources"
    )
    current_node_pools: Optional[List[StrictStr]] = Field(
        default=None, alias="currentNodePools"
    )
    running_pods: Optional[StrictInt] = Field(default=None, alias="runningPods")
    images: Optional[List[StrictStr]] = None
    environment_variables: Optional[Dict[str, StrictStr]] = Field(
        default=None, alias="environmentVariables"
    )
    command: Optional[StrictStr] = None
    arguments: Optional[StrictStr] = None
    children_ids: Optional[List[WorkloadChildrenIdsInner]] = Field(
        default=None, alias="childrenIds"
    )
    conditions: Optional[List[Condition1]] = None
    phase: Phase
    phase_message: Optional[StrictStr] = Field(default=None, alias="phaseMessage")
    phase_updated_at: Optional[datetime] = Field(default=None, alias="phaseUpdatedAt")
    additional_fields: Optional[Dict[str, Any]] = Field(
        default=None, alias="additionalFields"
    )
    __properties: ClassVar[List[str]] = [
        "type",
        "name",
        "id",
        "workloadId",
        "tenantId",
        "clusterId",
        "projectId",
        "departmentId",
        "createdAt",
        "deletedAt",
        "revisionRequestedResources",
        "podsRequestedResources",
        "requestedPods",
        "requestedNodePools",
        "allocatedResources",
        "currentNodePools",
        "runningPods",
        "images",
        "environmentVariables",
        "command",
        "arguments",
        "childrenIds",
        "conditions",
        "phase",
        "phaseMessage",
        "phaseUpdatedAt",
        "additionalFields",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Revision from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of revision_requested_resources
        if self.revision_requested_resources:
            _dict["revisionRequestedResources"] = (
                self.revision_requested_resources.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of pods_requested_resources
        if self.pods_requested_resources:
            _dict["podsRequestedResources"] = self.pods_requested_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_pods
        if self.requested_pods:
            _dict["requestedPods"] = self.requested_pods.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allocated_resources
        if self.allocated_resources:
            _dict["allocatedResources"] = self.allocated_resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in children_ids (list)
        _items = []
        if self.children_ids:
            for _item_children_ids in self.children_ids:
                if _item_children_ids:
                    _items.append(_item_children_ids.to_dict())
            _dict["childrenIds"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict["conditions"] = _items
        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict["deletedAt"] = None

        # set to None if revision_requested_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.revision_requested_resources is None
            and "revision_requested_resources" in self.model_fields_set
        ):
            _dict["revisionRequestedResources"] = None

        # set to None if pods_requested_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.pods_requested_resources is None
            and "pods_requested_resources" in self.model_fields_set
        ):
            _dict["podsRequestedResources"] = None

        # set to None if allocated_resources (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allocated_resources is None
            and "allocated_resources" in self.model_fields_set
        ):
            _dict["allocatedResources"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Revision from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "name": obj.get("name"),
                "id": obj.get("id"),
                "workloadId": obj.get("workloadId"),
                "tenantId": obj.get("tenantId"),
                "clusterId": obj.get("clusterId"),
                "projectId": obj.get("projectId"),
                "departmentId": obj.get("departmentId"),
                "createdAt": obj.get("createdAt"),
                "deletedAt": obj.get("deletedAt"),
                "revisionRequestedResources": (
                    WorkloadRequestResources.from_dict(
                        obj["revisionRequestedResources"]
                    )
                    if obj.get("revisionRequestedResources") is not None
                    else None
                ),
                "podsRequestedResources": (
                    WorkloadRequestResources.from_dict(obj["podsRequestedResources"])
                    if obj.get("podsRequestedResources") is not None
                    else None
                ),
                "requestedPods": (
                    RequestedPods.from_dict(obj["requestedPods"])
                    if obj.get("requestedPods") is not None
                    else None
                ),
                "requestedNodePools": obj.get("requestedNodePools"),
                "allocatedResources": (
                    WorkloadAllocatedResources.from_dict(obj["allocatedResources"])
                    if obj.get("allocatedResources") is not None
                    else None
                ),
                "currentNodePools": obj.get("currentNodePools"),
                "runningPods": obj.get("runningPods"),
                "images": obj.get("images"),
                "environmentVariables": obj.get("environmentVariables"),
                "command": obj.get("command"),
                "arguments": obj.get("arguments"),
                "childrenIds": (
                    [
                        WorkloadChildrenIdsInner.from_dict(_item)
                        for _item in obj["childrenIds"]
                    ]
                    if obj.get("childrenIds") is not None
                    else None
                ),
                "conditions": (
                    [Condition1.from_dict(_item) for _item in obj["conditions"]]
                    if obj.get("conditions") is not None
                    else None
                ),
                "phase": obj.get("phase"),
                "phaseMessage": obj.get("phaseMessage"),
                "phaseUpdatedAt": obj.get("phaseUpdatedAt"),
                "additionalFields": obj.get("additionalFields"),
            }
        )
        return _obj
