# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.kubernetes_permissions import KubernetesPermissions
from runai.models.permission import Permission
from typing import Optional, Set
from typing_extensions import Self


class RoleCreationFields(BaseModel):
    """
    Pydantic class model representing RoleCreationFields.

    Parameters:
        ```python
        name: str
        description: str
        permissions: List[Permission]
        enabled: Optional[bool]
        kubernetes_permissions: KubernetesPermissions
        ```
        name: See model str for more information.
        description: See model str for more information.
        permissions: See model List[Permission] for more information.
        enabled: See model bool for more information. - Default: True
        kubernetes_permissions: See model KubernetesPermissions for more information.
    Example:
        ```python
        RoleCreationFields(
            name='admin',
                        description='can manage all resources',
                        permissions=[
                    runai.models.permission.Permission(
                        resource_type = 'department',
                        display_name = 'Projects',
                        group_id = 'organization',
                        actions = [
                            'create'
                            ], )
                    ],
                        enabled=True,
                        kubernetes_permissions=runai.models.kubernetes_permissions.KubernetesPermissions(
                    predefined_role = '12', )
        )
        ```
    """  # noqa: E501

    name: StrictStr
    description: StrictStr
    permissions: List[Permission]
    enabled: Optional[StrictBool] = True
    kubernetes_permissions: Optional[KubernetesPermissions] = Field(
        default=None, alias="kubernetesPermissions"
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "permissions",
        "enabled",
        "kubernetesPermissions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RoleCreationFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item_permissions in self.permissions:
                if _item_permissions:
                    _items.append(_item_permissions.to_dict())
            _dict["permissions"] = _items
        # override the default output from pydantic by calling `to_dict()` of kubernetes_permissions
        if self.kubernetes_permissions:
            _dict["kubernetesPermissions"] = self.kubernetes_permissions.to_dict()
        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict["enabled"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RoleCreationFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "permissions": (
                    [Permission.from_dict(_item) for _item in obj["permissions"]]
                    if obj.get("permissions") is not None
                    else None
                ),
                "enabled": (
                    obj.get("enabled") if obj.get("enabled") is not None else True
                ),
                "kubernetesPermissions": (
                    KubernetesPermissions.from_dict(obj["kubernetesPermissions"])
                    if obj.get("kubernetesPermissions") is not None
                    else None
                ),
            }
        )
        return _obj
