# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.saml_creation_data_metadata_xml_type_enum import (
    SamlCreationDataMetadataXmlTypeEnum,
)
from typing import Optional, Set
from typing_extensions import Self


class SamlCreationData(BaseModel):
    """
    Pydantic class model representing SamlCreationData.

    Parameters:
        ```python
        metadata_xml_url: str
        metadata_xml_file: str
        file_name: str
        metadata_xml_type: SamlCreationDataMetadataXmlTypeEnum
        entity_id: str
        ```
        metadata_xml_url: See model str for more information.
        metadata_xml_file: See model str for more information.
        file_name: See model str for more information.
        metadata_xml_type: See model SamlCreationDataMetadataXmlTypeEnum for more information.
        entity_id: See model str for more information.
    Example:
        ```python
        SamlCreationData(
            metadata_xml_url='',
                        metadata_xml_file='',
                        file_name='',
                        metadata_xml_type='url',
                        entity_id=''
        )
        ```
    """  # noqa: E501

    metadata_xml_url: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None, alias="metadataXmlUrl"
    )
    metadata_xml_file: Optional[StrictStr] = Field(
        default=None, alias="metadataXmlFile"
    )
    file_name: Optional[StrictStr] = Field(default=None, alias="fileName")
    metadata_xml_type: Optional[SamlCreationDataMetadataXmlTypeEnum] = Field(
        default=None, alias="metadataXmlType"
    )
    entity_id: Optional[StrictStr] = Field(default=None, alias="entityId")
    __properties: ClassVar[List[str]] = [
        "metadataXmlUrl",
        "metadataXmlFile",
        "fileName",
        "metadataXmlType",
        "entityId",
    ]

    @field_validator("metadata_xml_url")
    def metadata_xml_url_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(
            r"^(https?://)?([a-zA-Z0-9.-]+\.[a-zA-Z]{2,})(:[0-9]{1,5})?(/[^\s]*)?$|^$",
            value,
        ):
            raise ValueError(
                r"must validate the regular expression /^(https?://)?([a-zA-Z0-9.-]+\.[a-zA-Z]{2,})(:[0-9]{1,5})?(/[^\s]*)?$|^$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SamlCreationData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SamlCreationData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "metadataXmlUrl": obj.get("metadataXmlUrl"),
                "metadataXmlFile": obj.get("metadataXmlFile"),
                "fileName": obj.get("fileName"),
                "metadataXmlType": obj.get("metadataXmlType"),
                "entityId": obj.get("entityId"),
            }
        )
        return _obj
