# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class SecretInstance2(BaseModel):
    """
    Pydantic class model representing SecretInstance2.

    Parameters:
        ```python
        name: Optional[str]
        mount_path: Optional[str]
        secret: Optional[str]
        exclude: Optional[bool]
        ```
        name: unique name to identify the instance. primarily used for policy locked rules.
        mount_path: Local path within the workload to which the Secret will be mapped to. (mandatory)
        secret: The name of the Secret resource. (mandatory)
        exclude: Use &#39;true&#39; in case the item is defined in defaults of the policy, and you wish to exclude it from the workload. - Default: False
    Example:
        ```python
        SecretInstance2(
            name='storage-instance-a',
                        mount_path='0',
                        secret='0',
                        exclude=False
        )
        ```
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="unique name to identify the instance. primarily used for policy locked rules.",
    )
    mount_path: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Local path within the workload to which the Secret will be mapped to. (mandatory)",
        alias="mountPath",
    )
    secret: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="The name of the Secret resource. (mandatory)"
    )
    exclude: Optional[StrictBool] = Field(
        default=False,
        description="Use 'true' in case the item is defined in defaults of the policy, and you wish to exclude it from the workload.",
    )
    __properties: ClassVar[List[str]] = ["name", "mountPath", "secret", "exclude"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecretInstance2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict["name"] = None

        # set to None if mount_path (nullable) is None
        # and model_fields_set contains the field
        if self.mount_path is None and "mount_path" in self.model_fields_set:
            _dict["mountPath"] = None

        # set to None if secret (nullable) is None
        # and model_fields_set contains the field
        if self.secret is None and "secret" in self.model_fields_set:
            _dict["secret"] = None

        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict["exclude"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecretInstance2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "mountPath": obj.get("mountPath"),
                "secret": obj.get("secret"),
                "exclude": (
                    obj.get("exclude") if obj.get("exclude") is not None else False
                ),
            }
        )
        return _obj
