# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class ServingPortAccessAuthorizationTypeEnum(str, Enum):
    """
    The authorization type for serving port URL access. Defaults to public, which means no authorization is required. If set to authenticatedUsers, only authenticated Run:ai users are allowed to access the URL. If set to authorizedUsersOrGroups, only users or groups specified in authorizedUsers or authorizedGroups are allowed to access the URL. Supported from cluster version 2.19.

    Allowed enum values:

    PUBLIC = 'public'

    AUTHENTICATEDUSERS = 'authenticatedUsers'

    AUTHORIZEDUSERSORGROUPS = 'authorizedUsersOrGroups'


    Example:
        ```python
        ServingPortAccessAuthorizationTypeEnum.PUBLIC
        ServingPortAccessAuthorizationTypeEnum.AUTHENTICATEDUSERS
        ServingPortAccessAuthorizationTypeEnum.AUTHORIZEDUSERSORGROUPS
        ```
    """

    PUBLIC = "public"
    AUTHENTICATEDUSERS = "authenticatedUsers"
    AUTHORIZEDUSERSORGROUPS = "authorizedUsersOrGroups"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ServingPortAccessAuthorizationTypeEnum from a JSON string"""
        return cls(json.loads(json_str))
