# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.array_rules import ArrayRules
from runai.models.boolean_rules import BooleanRules
from runai.models.integer_rules import IntegerRules
from runai.models.serving_port_authorization_type_rules import (
    ServingPortAuthorizationTypeRules,
)
from runai.models.serving_port_protocol_rules import ServingPortProtocolRules
from typing import Optional, Set
from typing_extensions import Self


class ServingPortRules(BaseModel):
    """
    Pydantic class model representing ServingPortRules.

    Parameters:
        ```python
        container: Optional[IntegerRules]
        protocol: Optional[ServingPortProtocolRules]
        authorization_type: Optional[ServingPortAuthorizationTypeRules]
        authorized_users: Optional[ArrayRules]
        authorized_groups: Optional[ArrayRules]
        cluster_local_access_only: Optional[BooleanRules]
        ```
        container: See model IntegerRules for more information.
        protocol: See model ServingPortProtocolRules for more information.
        authorization_type: See model ServingPortAuthorizationTypeRules for more information.
        authorized_users: See model ArrayRules for more information.
        authorized_groups: See model ArrayRules for more information.
        cluster_local_access_only: See model BooleanRules for more information.
    Example:
        ```python
        ServingPortRules(
            container=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        protocol=runai.models.serving_port_protocol_rules.ServingPortProtocolRules(),
                        authorization_type=runai.models.serving_port_authorization_type_rules.ServingPortAuthorizationTypeRules(),
                        authorized_users=runai.models.array_rules.ArrayRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    options = [
                        {"value":"value","displayed":"A description of the value."}
                        ],
                    can_edit = True, ),
                        authorized_groups=runai.models.array_rules.ArrayRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    options = [
                        {"value":"value","displayed":"A description of the value."}
                        ],
                    can_edit = True, ),
                        cluster_local_access_only=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, )
        )
        ```
    """  # noqa: E501

    container: Optional[IntegerRules] = None
    protocol: Optional[ServingPortProtocolRules] = None
    authorization_type: Optional[ServingPortAuthorizationTypeRules] = Field(
        default=None, alias="authorizationType"
    )
    authorized_users: Optional[ArrayRules] = Field(
        default=None, alias="authorizedUsers"
    )
    authorized_groups: Optional[ArrayRules] = Field(
        default=None, alias="authorizedGroups"
    )
    cluster_local_access_only: Optional[BooleanRules] = Field(
        default=None, alias="clusterLocalAccessOnly"
    )
    __properties: ClassVar[List[str]] = [
        "container",
        "protocol",
        "authorizationType",
        "authorizedUsers",
        "authorizedGroups",
        "clusterLocalAccessOnly",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServingPortRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container
        if self.container:
            _dict["container"] = self.container.to_dict()
        # override the default output from pydantic by calling `to_dict()` of protocol
        if self.protocol:
            _dict["protocol"] = self.protocol.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorization_type
        if self.authorization_type:
            _dict["authorizationType"] = self.authorization_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_users
        if self.authorized_users:
            _dict["authorizedUsers"] = self.authorized_users.to_dict()
        # override the default output from pydantic by calling `to_dict()` of authorized_groups
        if self.authorized_groups:
            _dict["authorizedGroups"] = self.authorized_groups.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cluster_local_access_only
        if self.cluster_local_access_only:
            _dict["clusterLocalAccessOnly"] = self.cluster_local_access_only.to_dict()
        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict["container"] = None

        # set to None if protocol (nullable) is None
        # and model_fields_set contains the field
        if self.protocol is None and "protocol" in self.model_fields_set:
            _dict["protocol"] = None

        # set to None if authorization_type (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorization_type is None
            and "authorization_type" in self.model_fields_set
        ):
            _dict["authorizationType"] = None

        # set to None if authorized_users (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_users is None
            and "authorized_users" in self.model_fields_set
        ):
            _dict["authorizedUsers"] = None

        # set to None if authorized_groups (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_groups is None
            and "authorized_groups" in self.model_fields_set
        ):
            _dict["authorizedGroups"] = None

        # set to None if cluster_local_access_only (nullable) is None
        # and model_fields_set contains the field
        if (
            self.cluster_local_access_only is None
            and "cluster_local_access_only" in self.model_fields_set
        ):
            _dict["clusterLocalAccessOnly"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServingPortRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "container": (
                    IntegerRules.from_dict(obj["container"])
                    if obj.get("container") is not None
                    else None
                ),
                "protocol": (
                    ServingPortProtocolRules.from_dict(obj["protocol"])
                    if obj.get("protocol") is not None
                    else None
                ),
                "authorizationType": (
                    ServingPortAuthorizationTypeRules.from_dict(
                        obj["authorizationType"]
                    )
                    if obj.get("authorizationType") is not None
                    else None
                ),
                "authorizedUsers": (
                    ArrayRules.from_dict(obj["authorizedUsers"])
                    if obj.get("authorizedUsers") is not None
                    else None
                ),
                "authorizedGroups": (
                    ArrayRules.from_dict(obj["authorizedGroups"])
                    if obj.get("authorizedGroups") is not None
                    else None
                ),
                "clusterLocalAccessOnly": (
                    BooleanRules.from_dict(obj["clusterLocalAccessOnly"])
                    if obj.get("clusterLocalAccessOnly") is not None
                    else None
                ),
            }
        )
        return _obj
