# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.auto_redirect_sso_setting import AutoRedirectSsoSetting
from runai.models.browser_session_timeout_setting import BrowserSessionTimeoutSetting
from runai.models.exclude_groups_from_token_setting import ExcludeGroupsFromTokenSetting
from runai.models.logout_redirect_uri_setting import LogoutRedirectUriSetting
from typing import Optional, Set
from typing_extensions import Self


class SettingsGetResponse(BaseModel):
    """
    Pydantic class model representing SettingsGetResponse.

    Parameters:
        ```python
        auto_redirect_sso: AutoRedirectSsoSetting
        exclude_groups_from_tokens: ExcludeGroupsFromTokenSetting
        browser_session_timeout: BrowserSessionTimeoutSetting
        logout_redirect_uri: LogoutRedirectUriSetting
        ```
        auto_redirect_sso: See model AutoRedirectSsoSetting for more information.
        exclude_groups_from_tokens: See model ExcludeGroupsFromTokenSetting for more information.
        browser_session_timeout: See model BrowserSessionTimeoutSetting for more information.
        logout_redirect_uri: See model LogoutRedirectUriSetting for more information.
    Example:
        ```python
        SettingsGetResponse(
            auto_redirect_sso={"enabled":false,"idpAlias":"oidc"},
                        exclude_groups_from_tokens={"enabled":false},
                        browser_session_timeout=runai.models.browser_session_timeout_setting.BrowserSessionTimeoutSetting(
                    idle_timeout = 1, ),
                        logout_redirect_uri=runai.models.logout_redirect_uri_setting.LogoutRedirectUriSetting(
                    uri = 'https://example.com/logout', )
        )
        ```
    """  # noqa: E501

    auto_redirect_sso: Optional[AutoRedirectSsoSetting] = Field(
        default=None, alias="autoRedirectSSO"
    )
    exclude_groups_from_tokens: Optional[ExcludeGroupsFromTokenSetting] = Field(
        default=None, alias="excludeGroupsFromTokens"
    )
    browser_session_timeout: Optional[BrowserSessionTimeoutSetting] = Field(
        default=None, alias="browserSessionTimeout"
    )
    logout_redirect_uri: Optional[LogoutRedirectUriSetting] = Field(
        default=None, alias="logoutRedirectUri"
    )
    __properties: ClassVar[List[str]] = [
        "autoRedirectSSO",
        "excludeGroupsFromTokens",
        "browserSessionTimeout",
        "logoutRedirectUri",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SettingsGetResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auto_redirect_sso
        if self.auto_redirect_sso:
            _dict["autoRedirectSSO"] = self.auto_redirect_sso.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exclude_groups_from_tokens
        if self.exclude_groups_from_tokens:
            _dict["excludeGroupsFromTokens"] = self.exclude_groups_from_tokens.to_dict()
        # override the default output from pydantic by calling `to_dict()` of browser_session_timeout
        if self.browser_session_timeout:
            _dict["browserSessionTimeout"] = self.browser_session_timeout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logout_redirect_uri
        if self.logout_redirect_uri:
            _dict["logoutRedirectUri"] = self.logout_redirect_uri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SettingsGetResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "autoRedirectSSO": (
                    AutoRedirectSsoSetting.from_dict(obj["autoRedirectSSO"])
                    if obj.get("autoRedirectSSO") is not None
                    else None
                ),
                "excludeGroupsFromTokens": (
                    ExcludeGroupsFromTokenSetting.from_dict(
                        obj["excludeGroupsFromTokens"]
                    )
                    if obj.get("excludeGroupsFromTokens") is not None
                    else None
                ),
                "browserSessionTimeout": (
                    BrowserSessionTimeoutSetting.from_dict(obj["browserSessionTimeout"])
                    if obj.get("browserSessionTimeout") is not None
                    else None
                ),
                "logoutRedirectUri": (
                    LogoutRedirectUriSetting.from_dict(obj["logoutRedirectUri"])
                    if obj.get("logoutRedirectUri") is not None
                    else None
                ),
            }
        )
        return _obj
