# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class SpecificRunAutoScalingAutoScaling(BaseModel):
    """
    Pydantic class model representing SpecificRunAutoScalingAutoScaling.

    Parameters:
        ```python
        metric_threshold_percentage: Optional[float]
        min_replicas: Optional[int]
        max_replicas: Optional[int]
        initial_replicas: Optional[int]
        activation_replicas: Optional[int]
        concurrency_hard_limit: Optional[int]
        scale_to_zero_retention_seconds: Optional[int]
        scale_down_delay_seconds: Optional[int]
        initialization_timeout_seconds: Optional[int]
        threshold_metric: Optional[str]
        threshold_value: Optional[int]
        ```
        metric_threshold_percentage: The percentage of metric threshold value to use for autoscaling. Defaults to 70. Applicable only with the &#39;throughput&#39; and &#39;concurrency&#39; metrics
        min_replicas: The minimum number of replicas for autoscaling. Defaults to 1. Use 0 to allow scale-to-zero
        max_replicas: The maximum number of replicas for autoscaling. Defaults to minReplicas, or to 1 if minReplicas is set to 0
        initial_replicas: The number of replicas to run when initializing the workload for the first time. Defaults to minReplicas, or to 1 if minReplicas is set to 0
        activation_replicas: The number of replicas to run when scaling-up from zero. Defaults to minReplicas, or to 1 if minReplicas is set to 0
        concurrency_hard_limit: The maximum number of requests allowed to flow to a single replica at any time. 0 means no limit
        scale_to_zero_retention_seconds: The minimum amount of time (in seconds) that the last replica will remain active after a scale-to-zero decision. Defaults to 0. Available only if minReplicas is set to 0
        scale_down_delay_seconds: The minimum amount of time (in seconds) that a replica will remain active after a scale-down decision
        initialization_timeout_seconds: Use &#x60;servingConfiguration.initializationTimeoutSeconds&#x60; instead.  If this field is set, it will be ignored and the value under &#x60;servingConfiguration&#x60; will be used. The maximum amount of time (in seconds) to wait for the container to become ready.
        threshold_metric: The metric to use for autoscaling. Mandatory if minReplicas &lt; maxReplicas, except for the special case where minReplicas is set to 0 and maxReplicas is set to 1, as in this case autoscaling decisions are made according to network activity rather than metrics. Use one of the built-in metrics of &#39;throughput&#39;, &#39;concurrency&#39; or &#39;latency&#39;, or any other available custom metric. Only the &#39;throughput&#39; and &#39;concurrency&#39; metrics support scale-to-zero
        threshold_value: The threshold value to use with the specified metric for autoscaling
    Example:
        ```python
        SpecificRunAutoScalingAutoScaling(
            metric_threshold_percentage=1,
                        min_replicas=0,
                        max_replicas=1,
                        initial_replicas=0,
                        activation_replicas=1,
                        concurrency_hard_limit=0,
                        scale_to_zero_retention_seconds=0,
                        scale_down_delay_seconds=0,
                        initialization_timeout_seconds=1,
                        threshold_metric='http_requests_total',
                        threshold_value=56
        )
        ```
    """  # noqa: E501

    metric_threshold_percentage: Optional[
        Union[
            Annotated[float, Field(le=100, strict=True, ge=1)],
            Annotated[int, Field(le=100, strict=True, ge=1)],
        ]
    ] = Field(
        default=None,
        description="The percentage of metric threshold value to use for autoscaling. Defaults to 70. Applicable only with the 'throughput' and 'concurrency' metrics",
        alias="metricThresholdPercentage",
    )
    min_replicas: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(
        default=None,
        description="The minimum number of replicas for autoscaling. Defaults to 1. Use 0 to allow scale-to-zero",
        alias="minReplicas",
    )
    max_replicas: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(
        default=None,
        description="The maximum number of replicas for autoscaling. Defaults to minReplicas, or to 1 if minReplicas is set to 0",
        alias="maxReplicas",
    )
    initial_replicas: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(
        default=None,
        description="The number of replicas to run when initializing the workload for the first time. Defaults to minReplicas, or to 1 if minReplicas is set to 0",
        alias="initialReplicas",
    )
    activation_replicas: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(
        default=None,
        description="The number of replicas to run when scaling-up from zero. Defaults to minReplicas, or to 1 if minReplicas is set to 0",
        alias="activationReplicas",
    )
    concurrency_hard_limit: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(
        default=None,
        description="The maximum number of requests allowed to flow to a single replica at any time. 0 means no limit",
        alias="concurrencyHardLimit",
    )
    scale_to_zero_retention_seconds: Optional[
        Annotated[int, Field(le=3600, strict=True, ge=0)]
    ] = Field(
        default=None,
        description="The minimum amount of time (in seconds) that the last replica will remain active after a scale-to-zero decision. Defaults to 0. Available only if minReplicas is set to 0",
        alias="scaleToZeroRetentionSeconds",
    )
    scale_down_delay_seconds: Optional[
        Annotated[int, Field(le=3600, strict=True, ge=0)]
    ] = Field(
        default=None,
        description="The minimum amount of time (in seconds) that a replica will remain active after a scale-down decision",
        alias="scaleDownDelaySeconds",
    )
    initialization_timeout_seconds: Optional[
        Annotated[int, Field(strict=True, ge=1)]
    ] = Field(
        default=None,
        description="Use `servingConfiguration.initializationTimeoutSeconds` instead.  If this field is set, it will be ignored and the value under `servingConfiguration` will be used. The maximum amount of time (in seconds) to wait for the container to become ready.",
        alias="initializationTimeoutSeconds",
    )
    threshold_metric: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="The metric to use for autoscaling. Mandatory if minReplicas < maxReplicas, except for the special case where minReplicas is set to 0 and maxReplicas is set to 1, as in this case autoscaling decisions are made according to network activity rather than metrics. Use one of the built-in metrics of 'throughput', 'concurrency' or 'latency', or any other available custom metric. Only the 'throughput' and 'concurrency' metrics support scale-to-zero",
        alias="thresholdMetric",
    )
    threshold_value: Optional[StrictInt] = Field(
        default=None,
        description="The threshold value to use with the specified metric for autoscaling",
        alias="thresholdValue",
    )
    __properties: ClassVar[List[str]] = [
        "metricThresholdPercentage",
        "minReplicas",
        "maxReplicas",
        "initialReplicas",
        "activationReplicas",
        "concurrencyHardLimit",
        "scaleToZeroRetentionSeconds",
        "scaleDownDelaySeconds",
        "initializationTimeoutSeconds",
        "thresholdMetric",
        "thresholdValue",
    ]

    @field_validator("threshold_metric")
    def threshold_metric_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z_:][a-zA-Z0-9_:]*$", value):
            raise ValueError(
                r"must validate the regular expression /^[a-zA-Z_:][a-zA-Z0-9_:]*$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecificRunAutoScalingAutoScaling from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metric_threshold_percentage (nullable) is None
        # and model_fields_set contains the field
        if (
            self.metric_threshold_percentage is None
            and "metric_threshold_percentage" in self.model_fields_set
        ):
            _dict["metricThresholdPercentage"] = None

        # set to None if min_replicas (nullable) is None
        # and model_fields_set contains the field
        if self.min_replicas is None and "min_replicas" in self.model_fields_set:
            _dict["minReplicas"] = None

        # set to None if max_replicas (nullable) is None
        # and model_fields_set contains the field
        if self.max_replicas is None and "max_replicas" in self.model_fields_set:
            _dict["maxReplicas"] = None

        # set to None if initial_replicas (nullable) is None
        # and model_fields_set contains the field
        if (
            self.initial_replicas is None
            and "initial_replicas" in self.model_fields_set
        ):
            _dict["initialReplicas"] = None

        # set to None if activation_replicas (nullable) is None
        # and model_fields_set contains the field
        if (
            self.activation_replicas is None
            and "activation_replicas" in self.model_fields_set
        ):
            _dict["activationReplicas"] = None

        # set to None if concurrency_hard_limit (nullable) is None
        # and model_fields_set contains the field
        if (
            self.concurrency_hard_limit is None
            and "concurrency_hard_limit" in self.model_fields_set
        ):
            _dict["concurrencyHardLimit"] = None

        # set to None if scale_to_zero_retention_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.scale_to_zero_retention_seconds is None
            and "scale_to_zero_retention_seconds" in self.model_fields_set
        ):
            _dict["scaleToZeroRetentionSeconds"] = None

        # set to None if scale_down_delay_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.scale_down_delay_seconds is None
            and "scale_down_delay_seconds" in self.model_fields_set
        ):
            _dict["scaleDownDelaySeconds"] = None

        # set to None if initialization_timeout_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.initialization_timeout_seconds is None
            and "initialization_timeout_seconds" in self.model_fields_set
        ):
            _dict["initializationTimeoutSeconds"] = None

        # set to None if threshold_metric (nullable) is None
        # and model_fields_set contains the field
        if (
            self.threshold_metric is None
            and "threshold_metric" in self.model_fields_set
        ):
            _dict["thresholdMetric"] = None

        # set to None if threshold_value (nullable) is None
        # and model_fields_set contains the field
        if self.threshold_value is None and "threshold_value" in self.model_fields_set:
            _dict["thresholdValue"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecificRunAutoScalingAutoScaling from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "metricThresholdPercentage": obj.get("metricThresholdPercentage"),
                "minReplicas": obj.get("minReplicas"),
                "maxReplicas": obj.get("maxReplicas"),
                "initialReplicas": obj.get("initialReplicas"),
                "activationReplicas": obj.get("activationReplicas"),
                "concurrencyHardLimit": obj.get("concurrencyHardLimit"),
                "scaleToZeroRetentionSeconds": obj.get("scaleToZeroRetentionSeconds"),
                "scaleDownDelaySeconds": obj.get("scaleDownDelaySeconds"),
                "initializationTimeoutSeconds": obj.get("initializationTimeoutSeconds"),
                "thresholdMetric": obj.get("thresholdMetric"),
                "thresholdValue": obj.get("thresholdValue"),
            }
        )
        return _obj
