# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class SpecificRunConnectionInfo(BaseModel):
    """
    Pydantic class model representing SpecificRunConnectionInfo.

    Parameters:
        ```python
        name: str
        node_port: Optional[int]
        external_url: Optional[str]
        authorized_users: Optional[List[str]]
        authorized_groups: Optional[List[str]]
        ```
        name: Unique identifier of the connection. Will be used to correlate between the information given here and the information provided for the connection in the environment asset.
        node_port: Port number of the host that will be connected with the container port. Required if and only if isCustomPort is set to true in the environment asset.
        external_url: URL to associated with the container port. Required if and only if isCustomExternalUrl is set to true in the environment asset.
        authorized_users: Specifies the emails of those users that are allowed to access the connection. Note that authorizedUsers and authorizedGroups are mutually exclusive.
        authorized_groups: Specifies the names of those groups that are allowed to access the connection. Note that authorizedUsers and authorizedGroups are mutually exclusive.
    Example:
        ```python
        SpecificRunConnectionInfo(
            name='0',
                        node_port=0,
                        external_url='0',
                        authorized_users=[
                    ''
                    ],
                        authorized_groups=[
                    ''
                    ]
        )
        ```
    """  # noqa: E501

    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="Unique identifier of the connection. Will be used to correlate between the information given here and the information provided for the connection in the environment asset.",
    )
    node_port: Optional[Annotated[int, Field(le=65535, strict=True, ge=0)]] = Field(
        default=None,
        description="Port number of the host that will be connected with the container port. Required if and only if isCustomPort is set to true in the environment asset.",
        alias="nodePort",
    )
    external_url: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None,
        description="URL to associated with the container port. Required if and only if isCustomExternalUrl is set to true in the environment asset.",
        alias="externalUrl",
    )
    authorized_users: Optional[List[StrictStr]] = Field(
        default=None,
        description="Specifies the emails of those users that are allowed to access the connection. Note that authorizedUsers and authorizedGroups are mutually exclusive.",
        alias="authorizedUsers",
    )
    authorized_groups: Optional[List[StrictStr]] = Field(
        default=None,
        description="Specifies the names of those groups that are allowed to access the connection. Note that authorizedUsers and authorizedGroups are mutually exclusive.",
        alias="authorizedGroups",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "nodePort",
        "externalUrl",
        "authorizedUsers",
        "authorizedGroups",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecificRunConnectionInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if node_port (nullable) is None
        # and model_fields_set contains the field
        if self.node_port is None and "node_port" in self.model_fields_set:
            _dict["nodePort"] = None

        # set to None if external_url (nullable) is None
        # and model_fields_set contains the field
        if self.external_url is None and "external_url" in self.model_fields_set:
            _dict["externalUrl"] = None

        # set to None if authorized_users (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_users is None
            and "authorized_users" in self.model_fields_set
        ):
            _dict["authorizedUsers"] = None

        # set to None if authorized_groups (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_groups is None
            and "authorized_groups" in self.model_fields_set
        ):
            _dict["authorizedGroups"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecificRunConnectionInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "nodePort": obj.get("nodePort"),
                "externalUrl": obj.get("externalUrl"),
                "authorizedUsers": obj.get("authorizedUsers"),
                "authorizedGroups": obj.get("authorizedGroups"),
            }
        )
        return _obj
