# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.arbitrary_rules import ArbitraryRules
from runai.models.boolean_rules import BooleanRules
from runai.models.image_pull_secrets_rules import ImagePullSecretsRules
from runai.models.instances_rules import InstancesRules
from runai.models.integer_rules import IntegerRules
from runai.models.integer_rules_optional import IntegerRulesOptional
from runai.models.pod_affinity_rules import PodAffinityRules
from runai.models.restart_policy_rule import RestartPolicyRule
from runai.models.string_rules import StringRules
from runai.models.tolerations_rules import TolerationsRules
from typing import Optional, Set
from typing_extensions import Self


class SpecificRunParamsCommonRules(BaseModel):
    """
    Pydantic class model representing SpecificRunParamsCommonRules.

    Parameters:
        ```python
        command: Optional[StringRules]
        args: Optional[StringRules]
        run_as_uid: Optional[IntegerRulesOptional]
        run_as_gid: Optional[IntegerRulesOptional]
        supplemental_groups: Optional[StringRules]
        environment_variables: Optional[InstancesRules]
        node_type: Optional[StringRules]
        node_affinity_required: Optional[ArbitraryRules]
        pod_affinity: Optional[PodAffinityRules]
        category: Optional[StringRules]
        priority_class: Optional[StringRules]
        terminate_after_preemption: Optional[BooleanRules]
        auto_deletion_time_after_completion_seconds: Optional[IntegerRules]
        termination_grace_period_seconds: Optional[IntegerRules]
        backoff_limit: Optional[IntegerRules]
        restart_policy: Optional[RestartPolicyRule]
        annotations: Optional[InstancesRules]
        labels: Optional[InstancesRules]
        image_pull_secrets: Optional[ImagePullSecretsRules]
        tolerations: Optional[TolerationsRules]
        parallelism: Optional[IntegerRules]
        completions: Optional[IntegerRules]
        ```
        command: See model StringRules for more information.
        args: See model StringRules for more information.
        run_as_uid: See model IntegerRulesOptional for more information.
        run_as_gid: See model IntegerRulesOptional for more information.
        supplemental_groups: See model StringRules for more information.
        environment_variables: See model InstancesRules for more information.
        node_type: See model StringRules for more information.
        node_affinity_required: See model ArbitraryRules for more information.
        pod_affinity: See model PodAffinityRules for more information.
        category: See model StringRules for more information.
        priority_class: See model StringRules for more information.
        terminate_after_preemption: See model BooleanRules for more information.
        auto_deletion_time_after_completion_seconds: See model IntegerRules for more information.
        termination_grace_period_seconds: See model IntegerRules for more information.
        backoff_limit: See model IntegerRules for more information.
        restart_policy: See model RestartPolicyRule for more information.
        annotations: See model InstancesRules for more information.
        labels: See model InstancesRules for more information.
        image_pull_secrets: See model ImagePullSecretsRules for more information.
        tolerations: See model TolerationsRules for more information.
        parallelism: See model IntegerRules for more information.
        completions: See model IntegerRules for more information.
    Example:
        ```python
        SpecificRunParamsCommonRules(
            command=runai.models.string_rules.StringRules(),
                        args=runai.models.string_rules.StringRules(),
                        run_as_uid=runai.models.integer_rules_optional.IntegerRulesOptional(
                    source_of_rule = {"scope":"project","projectId":3},
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        run_as_gid=runai.models.integer_rules_optional.IntegerRulesOptional(
                    source_of_rule = {"scope":"project","projectId":3},
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        supplemental_groups=runai.models.string_rules.StringRules(),
                        environment_variables=runai.models.instances_rules.InstancesRules(
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        node_type=runai.models.string_rules.StringRules(),
                        node_affinity_required=runai.models.arbitrary_rules.ArbitraryRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        pod_affinity=runai.models.pod_affinity_rules.PodAffinityRules(
                    type = runai.models.pod_affinity_type_rules.PodAffinityTypeRules(),
                    key = runai.models.string_rules.StringRules(), ),
                        category=runai.models.string_rules.StringRules(),
                        priority_class=runai.models.string_rules.StringRules(),
                        terminate_after_preemption=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, ),
                        auto_deletion_time_after_completion_seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        termination_grace_period_seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        backoff_limit=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        restart_policy=runai.models.restart_policy_rule.RestartPolicyRule(),
                        annotations=runai.models.instances_rules.InstancesRules(
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        labels=runai.models.instances_rules.InstancesRules(
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        image_pull_secrets=runai.models.image_pull_secrets_rules.ImagePullSecretsRules(
                    attributes = runai.models.image_pull_secrets_rules_attributes.ImagePullSecretsRulesAttributes(
                        name = runai.models.string_rules.StringRules(),
                        user_credentials = runai.models.boolean_rules.BooleanRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True, ), ),
                    instances = runai.models.item_rules.ItemRules(
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        tolerations=runai.models.tolerations_rules.TolerationsRules(
                    attributes = runai.models.toleration_rules.TolerationRules(
                        operator = runai.models.toleration_operator_rules.TolerationOperatorRules(),
                        key = runai.models.string_rules.StringRules(),
                        value = runai.models.string_rules.StringRules(),
                        effect = runai.models.toleration_effect_rules.TolerationEffectRules(),
                        seconds = runai.models.integer_rules.IntegerRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True,
                            min = 56,
                            max = 56,
                            step = 56,
                            default_from = runai.models.default_from_rule.DefaultFromRule(
                                field = '',
                                factor = 1.337, ), ),
                        exclude = runai.models.boolean_rules.BooleanRules(
                            required = True,
                            can_edit = True, ), ),
                    instances = runai.models.item_rules.ItemRules(
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        parallelism=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        completions=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), )
        )
        ```
    """  # noqa: E501

    command: Optional[StringRules] = None
    args: Optional[StringRules] = None
    run_as_uid: Optional[IntegerRulesOptional] = Field(default=None, alias="runAsUid")
    run_as_gid: Optional[IntegerRulesOptional] = Field(default=None, alias="runAsGid")
    supplemental_groups: Optional[StringRules] = Field(
        default=None, alias="supplementalGroups"
    )
    environment_variables: Optional[InstancesRules] = Field(
        default=None, alias="environmentVariables"
    )
    node_type: Optional[StringRules] = Field(default=None, alias="nodeType")
    node_affinity_required: Optional[ArbitraryRules] = Field(
        default=None, alias="nodeAffinityRequired"
    )
    pod_affinity: Optional[PodAffinityRules] = Field(default=None, alias="podAffinity")
    category: Optional[StringRules] = None
    priority_class: Optional[StringRules] = Field(default=None, alias="priorityClass")
    terminate_after_preemption: Optional[BooleanRules] = Field(
        default=None, alias="terminateAfterPreemption"
    )
    auto_deletion_time_after_completion_seconds: Optional[IntegerRules] = Field(
        default=None, alias="autoDeletionTimeAfterCompletionSeconds"
    )
    termination_grace_period_seconds: Optional[IntegerRules] = Field(
        default=None, alias="terminationGracePeriodSeconds"
    )
    backoff_limit: Optional[IntegerRules] = Field(default=None, alias="backoffLimit")
    restart_policy: Optional[RestartPolicyRule] = Field(
        default=None, alias="restartPolicy"
    )
    annotations: Optional[InstancesRules] = None
    labels: Optional[InstancesRules] = None
    image_pull_secrets: Optional[ImagePullSecretsRules] = Field(
        default=None, alias="imagePullSecrets"
    )
    tolerations: Optional[TolerationsRules] = None
    parallelism: Optional[IntegerRules] = None
    completions: Optional[IntegerRules] = None
    __properties: ClassVar[List[str]] = [
        "command",
        "args",
        "runAsUid",
        "runAsGid",
        "supplementalGroups",
        "environmentVariables",
        "nodeType",
        "nodeAffinityRequired",
        "podAffinity",
        "category",
        "priorityClass",
        "terminateAfterPreemption",
        "autoDeletionTimeAfterCompletionSeconds",
        "terminationGracePeriodSeconds",
        "backoffLimit",
        "restartPolicy",
        "annotations",
        "labels",
        "imagePullSecrets",
        "tolerations",
        "parallelism",
        "completions",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecificRunParamsCommonRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of command
        if self.command:
            _dict["command"] = self.command.to_dict()
        # override the default output from pydantic by calling `to_dict()` of args
        if self.args:
            _dict["args"] = self.args.to_dict()
        # override the default output from pydantic by calling `to_dict()` of run_as_uid
        if self.run_as_uid:
            _dict["runAsUid"] = self.run_as_uid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of run_as_gid
        if self.run_as_gid:
            _dict["runAsGid"] = self.run_as_gid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of supplemental_groups
        if self.supplemental_groups:
            _dict["supplementalGroups"] = self.supplemental_groups.to_dict()
        # override the default output from pydantic by calling `to_dict()` of environment_variables
        if self.environment_variables:
            _dict["environmentVariables"] = self.environment_variables.to_dict()
        # override the default output from pydantic by calling `to_dict()` of node_type
        if self.node_type:
            _dict["nodeType"] = self.node_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of node_affinity_required
        if self.node_affinity_required:
            _dict["nodeAffinityRequired"] = self.node_affinity_required.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pod_affinity
        if self.pod_affinity:
            _dict["podAffinity"] = self.pod_affinity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict["category"] = self.category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of priority_class
        if self.priority_class:
            _dict["priorityClass"] = self.priority_class.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terminate_after_preemption
        if self.terminate_after_preemption:
            _dict["terminateAfterPreemption"] = (
                self.terminate_after_preemption.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of auto_deletion_time_after_completion_seconds
        if self.auto_deletion_time_after_completion_seconds:
            _dict["autoDeletionTimeAfterCompletionSeconds"] = (
                self.auto_deletion_time_after_completion_seconds.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of termination_grace_period_seconds
        if self.termination_grace_period_seconds:
            _dict["terminationGracePeriodSeconds"] = (
                self.termination_grace_period_seconds.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of backoff_limit
        if self.backoff_limit:
            _dict["backoffLimit"] = self.backoff_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restart_policy
        if self.restart_policy:
            _dict["restartPolicy"] = self.restart_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of annotations
        if self.annotations:
            _dict["annotations"] = self.annotations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of labels
        if self.labels:
            _dict["labels"] = self.labels.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_pull_secrets
        if self.image_pull_secrets:
            _dict["imagePullSecrets"] = self.image_pull_secrets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tolerations
        if self.tolerations:
            _dict["tolerations"] = self.tolerations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parallelism
        if self.parallelism:
            _dict["parallelism"] = self.parallelism.to_dict()
        # override the default output from pydantic by calling `to_dict()` of completions
        if self.completions:
            _dict["completions"] = self.completions.to_dict()
        # set to None if command (nullable) is None
        # and model_fields_set contains the field
        if self.command is None and "command" in self.model_fields_set:
            _dict["command"] = None

        # set to None if args (nullable) is None
        # and model_fields_set contains the field
        if self.args is None and "args" in self.model_fields_set:
            _dict["args"] = None

        # set to None if run_as_uid (nullable) is None
        # and model_fields_set contains the field
        if self.run_as_uid is None and "run_as_uid" in self.model_fields_set:
            _dict["runAsUid"] = None

        # set to None if run_as_gid (nullable) is None
        # and model_fields_set contains the field
        if self.run_as_gid is None and "run_as_gid" in self.model_fields_set:
            _dict["runAsGid"] = None

        # set to None if supplemental_groups (nullable) is None
        # and model_fields_set contains the field
        if (
            self.supplemental_groups is None
            and "supplemental_groups" in self.model_fields_set
        ):
            _dict["supplementalGroups"] = None

        # set to None if environment_variables (nullable) is None
        # and model_fields_set contains the field
        if (
            self.environment_variables is None
            and "environment_variables" in self.model_fields_set
        ):
            _dict["environmentVariables"] = None

        # set to None if node_type (nullable) is None
        # and model_fields_set contains the field
        if self.node_type is None and "node_type" in self.model_fields_set:
            _dict["nodeType"] = None

        # set to None if node_affinity_required (nullable) is None
        # and model_fields_set contains the field
        if (
            self.node_affinity_required is None
            and "node_affinity_required" in self.model_fields_set
        ):
            _dict["nodeAffinityRequired"] = None

        # set to None if pod_affinity (nullable) is None
        # and model_fields_set contains the field
        if self.pod_affinity is None and "pod_affinity" in self.model_fields_set:
            _dict["podAffinity"] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict["category"] = None

        # set to None if priority_class (nullable) is None
        # and model_fields_set contains the field
        if self.priority_class is None and "priority_class" in self.model_fields_set:
            _dict["priorityClass"] = None

        # set to None if terminate_after_preemption (nullable) is None
        # and model_fields_set contains the field
        if (
            self.terminate_after_preemption is None
            and "terminate_after_preemption" in self.model_fields_set
        ):
            _dict["terminateAfterPreemption"] = None

        # set to None if auto_deletion_time_after_completion_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.auto_deletion_time_after_completion_seconds is None
            and "auto_deletion_time_after_completion_seconds" in self.model_fields_set
        ):
            _dict["autoDeletionTimeAfterCompletionSeconds"] = None

        # set to None if termination_grace_period_seconds (nullable) is None
        # and model_fields_set contains the field
        if (
            self.termination_grace_period_seconds is None
            and "termination_grace_period_seconds" in self.model_fields_set
        ):
            _dict["terminationGracePeriodSeconds"] = None

        # set to None if backoff_limit (nullable) is None
        # and model_fields_set contains the field
        if self.backoff_limit is None and "backoff_limit" in self.model_fields_set:
            _dict["backoffLimit"] = None

        # set to None if restart_policy (nullable) is None
        # and model_fields_set contains the field
        if self.restart_policy is None and "restart_policy" in self.model_fields_set:
            _dict["restartPolicy"] = None

        # set to None if annotations (nullable) is None
        # and model_fields_set contains the field
        if self.annotations is None and "annotations" in self.model_fields_set:
            _dict["annotations"] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict["labels"] = None

        # set to None if image_pull_secrets (nullable) is None
        # and model_fields_set contains the field
        if (
            self.image_pull_secrets is None
            and "image_pull_secrets" in self.model_fields_set
        ):
            _dict["imagePullSecrets"] = None

        # set to None if tolerations (nullable) is None
        # and model_fields_set contains the field
        if self.tolerations is None and "tolerations" in self.model_fields_set:
            _dict["tolerations"] = None

        # set to None if parallelism (nullable) is None
        # and model_fields_set contains the field
        if self.parallelism is None and "parallelism" in self.model_fields_set:
            _dict["parallelism"] = None

        # set to None if completions (nullable) is None
        # and model_fields_set contains the field
        if self.completions is None and "completions" in self.model_fields_set:
            _dict["completions"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecificRunParamsCommonRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "command": (
                    StringRules.from_dict(obj["command"])
                    if obj.get("command") is not None
                    else None
                ),
                "args": (
                    StringRules.from_dict(obj["args"])
                    if obj.get("args") is not None
                    else None
                ),
                "runAsUid": (
                    IntegerRulesOptional.from_dict(obj["runAsUid"])
                    if obj.get("runAsUid") is not None
                    else None
                ),
                "runAsGid": (
                    IntegerRulesOptional.from_dict(obj["runAsGid"])
                    if obj.get("runAsGid") is not None
                    else None
                ),
                "supplementalGroups": (
                    StringRules.from_dict(obj["supplementalGroups"])
                    if obj.get("supplementalGroups") is not None
                    else None
                ),
                "environmentVariables": (
                    InstancesRules.from_dict(obj["environmentVariables"])
                    if obj.get("environmentVariables") is not None
                    else None
                ),
                "nodeType": (
                    StringRules.from_dict(obj["nodeType"])
                    if obj.get("nodeType") is not None
                    else None
                ),
                "nodeAffinityRequired": (
                    ArbitraryRules.from_dict(obj["nodeAffinityRequired"])
                    if obj.get("nodeAffinityRequired") is not None
                    else None
                ),
                "podAffinity": (
                    PodAffinityRules.from_dict(obj["podAffinity"])
                    if obj.get("podAffinity") is not None
                    else None
                ),
                "category": (
                    StringRules.from_dict(obj["category"])
                    if obj.get("category") is not None
                    else None
                ),
                "priorityClass": (
                    StringRules.from_dict(obj["priorityClass"])
                    if obj.get("priorityClass") is not None
                    else None
                ),
                "terminateAfterPreemption": (
                    BooleanRules.from_dict(obj["terminateAfterPreemption"])
                    if obj.get("terminateAfterPreemption") is not None
                    else None
                ),
                "autoDeletionTimeAfterCompletionSeconds": (
                    IntegerRules.from_dict(
                        obj["autoDeletionTimeAfterCompletionSeconds"]
                    )
                    if obj.get("autoDeletionTimeAfterCompletionSeconds") is not None
                    else None
                ),
                "terminationGracePeriodSeconds": (
                    IntegerRules.from_dict(obj["terminationGracePeriodSeconds"])
                    if obj.get("terminationGracePeriodSeconds") is not None
                    else None
                ),
                "backoffLimit": (
                    IntegerRules.from_dict(obj["backoffLimit"])
                    if obj.get("backoffLimit") is not None
                    else None
                ),
                "restartPolicy": (
                    RestartPolicyRule.from_dict(obj["restartPolicy"])
                    if obj.get("restartPolicy") is not None
                    else None
                ),
                "annotations": (
                    InstancesRules.from_dict(obj["annotations"])
                    if obj.get("annotations") is not None
                    else None
                ),
                "labels": (
                    InstancesRules.from_dict(obj["labels"])
                    if obj.get("labels") is not None
                    else None
                ),
                "imagePullSecrets": (
                    ImagePullSecretsRules.from_dict(obj["imagePullSecrets"])
                    if obj.get("imagePullSecrets") is not None
                    else None
                ),
                "tolerations": (
                    TolerationsRules.from_dict(obj["tolerations"])
                    if obj.get("tolerations") is not None
                    else None
                ),
                "parallelism": (
                    IntegerRules.from_dict(obj["parallelism"])
                    if obj.get("parallelism") is not None
                    else None
                ),
                "completions": (
                    IntegerRules.from_dict(obj["completions"])
                    if obj.get("completions") is not None
                    else None
                ),
            }
        )
        return _obj
