# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class StorageClassPermissions(BaseModel):
    """
    Pydantic class model representing StorageClassPermissions.

    Parameters:
        ```python
        allowed_for_assets: Optional[bool]
        allowed_for_workloads: Optional[bool]
        allowed_for_ephemeral_volumes: Optional[bool]
        allowed_for_persistent_volumes: Optional[bool]
        allow_data_sharing: Optional[bool]
        ```
        allowed_for_assets: Permission to create PVC assets on this storage class.
        allowed_for_workloads: Permission to include PVCs that use this storage class in workloads. With this permission flag set to off, user will not be able to (a) include non-existing PVC asset, created on this storage class, in asset based submission. (b) include PVC instance with existing&#x3D;false, that uses this storage class.
        allowed_for_ephemeral_volumes: Permission to allow workload to create ephemeral volumes on this storage class With this permission flag set to off, user will not be able to (a) create PVC asset with autoDelete&#x3D;true and ephemeral&#x3D;true (b) include PVC instance with isEphemeral&#x3D;false, that uses this storage class.
        allowed_for_persistent_volumes: Permission to allow workload to create persistent volumes on this storage class With this permission flag set to off, user will not be able to (a) create PVC asset with autoDelete&#x3D;true and ephemeral&#x3D;true (b) include PVC instance with isEphemeral&#x3D;false, that uses this storage class.
        allow_data_sharing: Permission to create a PVC using a shared volume
    Example:
        ```python
        StorageClassPermissions(
            allowed_for_assets=True,
                        allowed_for_workloads=True,
                        allowed_for_ephemeral_volumes=True,
                        allowed_for_persistent_volumes=True,
                        allow_data_sharing=True
        )
        ```
    """  # noqa: E501

    allowed_for_assets: Optional[StrictBool] = Field(
        default=None,
        description="Permission to create PVC assets on this storage class.",
        alias="allowedForAssets",
    )
    allowed_for_workloads: Optional[StrictBool] = Field(
        default=None,
        description="Permission to include PVCs that use this storage class in workloads. With this permission flag set to off, user will not be able to (a) include non-existing PVC asset, created on this storage class, in asset based submission. (b) include PVC instance with existing=false, that uses this storage class.",
        alias="allowedForWorkloads",
    )
    allowed_for_ephemeral_volumes: Optional[StrictBool] = Field(
        default=None,
        description="Permission to allow workload to create ephemeral volumes on this storage class With this permission flag set to off, user will not be able to (a) create PVC asset with autoDelete=true and ephemeral=true (b) include PVC instance with isEphemeral=false, that uses this storage class.",
        alias="allowedForEphemeralVolumes",
    )
    allowed_for_persistent_volumes: Optional[StrictBool] = Field(
        default=None,
        description="Permission to allow workload to create persistent volumes on this storage class With this permission flag set to off, user will not be able to (a) create PVC asset with autoDelete=true and ephemeral=true (b) include PVC instance with isEphemeral=false, that uses this storage class.",
        alias="allowedForPersistentVolumes",
    )
    allow_data_sharing: Optional[StrictBool] = Field(
        default=None,
        description="Permission to create a PVC using a shared volume",
        alias="allowDataSharing",
    )
    __properties: ClassVar[List[str]] = [
        "allowedForAssets",
        "allowedForWorkloads",
        "allowedForEphemeralVolumes",
        "allowedForPersistentVolumes",
        "allowDataSharing",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageClassPermissions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if allowed_for_assets (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allowed_for_assets is None
            and "allowed_for_assets" in self.model_fields_set
        ):
            _dict["allowedForAssets"] = None

        # set to None if allowed_for_workloads (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allowed_for_workloads is None
            and "allowed_for_workloads" in self.model_fields_set
        ):
            _dict["allowedForWorkloads"] = None

        # set to None if allowed_for_ephemeral_volumes (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allowed_for_ephemeral_volumes is None
            and "allowed_for_ephemeral_volumes" in self.model_fields_set
        ):
            _dict["allowedForEphemeralVolumes"] = None

        # set to None if allowed_for_persistent_volumes (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allowed_for_persistent_volumes is None
            and "allowed_for_persistent_volumes" in self.model_fields_set
        ):
            _dict["allowedForPersistentVolumes"] = None

        # set to None if allow_data_sharing (nullable) is None
        # and model_fields_set contains the field
        if (
            self.allow_data_sharing is None
            and "allow_data_sharing" in self.model_fields_set
        ):
            _dict["allowDataSharing"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageClassPermissions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "allowedForAssets": obj.get("allowedForAssets"),
                "allowedForWorkloads": obj.get("allowedForWorkloads"),
                "allowedForEphemeralVolumes": obj.get("allowedForEphemeralVolumes"),
                "allowedForPersistentVolumes": obj.get("allowedForPersistentVolumes"),
                "allowDataSharing": obj.get("allowDataSharing"),
            }
        )
        return _obj
