# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.storage_class_customization import StorageClassCustomization
from runai.models.storage_class_permissions import StorageClassPermissions
from runai.models.storage_class_spec import StorageClassSpec
from typing import Optional, Set
from typing_extensions import Self


class StorageClassV2(BaseModel):
    """
    Pydantic class model representing StorageClassV2.

    Parameters:
        ```python
        cluster_id: str
        storage_class_name: str
        spec: StorageClassSpec
        permissions: Optional[StorageClassPermissions]
        customization: Optional[StorageClassCustomization]
        ```
        cluster_id: Cluster ID which has sent the resource info
        storage_class_name: Storage class name
        spec: See model StorageClassSpec for more information.
        permissions: See model StorageClassPermissions for more information.
        customization: See model StorageClassCustomization for more information.
    Example:
        ```python
        StorageClassV2(
            cluster_id='550e8400-e29b-41d4-a716-446655440000',
                        storage_class_name='my-storage-class',
                        spec=runai.models.storage_class_spec.StorageClassSpec(
                    provisioner = 'kubernetes.io/aws-ebs',
                    allow_volume_expansion = True,
                    is_default = False, ),
                        permissions=runai.models.storage_class_permissions.StorageClassPermissions(
                    allowed_for_assets = True,
                    allowed_for_workloads = True,
                    allowed_for_ephemeral_volumes = True,
                    allowed_for_persistent_volumes = True,
                    allow_data_sharing = True, ),
                        customization=runai.models.storage_class_customization.StorageClassCustomization(
                    access_mode = runai.models.access_mode_customization.AccessModeCustomization(
                        required = True,
                        default = runai.models.pvc_access_modes.PvcAccessModes(
                            read_write_once = True,
                            read_only_many = True,
                            read_write_many = True, ),
                        supported_values = runai.models.pvc_supported_access_modes.PvcSupportedAccessModes(
                            read_write_once = True,
                            read_only_many = True,
                            read_write_many = True, ), ),
                    volume_mode = runai.models.volume_mode_customization.VolumeModeCustomization(
                        required = True, ),
                    claim_size = runai.models.claim_size_customization.ClaimSizeCustomization(
                        supported_units = [
                            'MB'
                            ],
                        min = '1G',
                        max = '1G',
                        step = '1G', ),
                    attributes = [
                        runai.models.pvc_added_attribute.PvcAddedAttribute(
                            key = 'dnsname',
                            format = 'text',
                            display = 'DNS Name',
                            description = 'The host name of the DNS',
                            placeholder = 'enter hostname or IP address',
                            required = True,
                            default_value = 'my.dns.com',
                            validation_regexp = '^[a-zA-Z0-9.-_]+$',
                            min_value = 100,
                            max_value = 200,
                            step = 5,
                            validation_error = 'Invalid URL', )
                        ], )
        )
        ```
    """  # noqa: E501

    cluster_id: StrictStr = Field(
        description="Cluster ID which has sent the resource info", alias="clusterId"
    )
    storage_class_name: StrictStr = Field(
        description="Storage class name", alias="storageClassName"
    )
    spec: StorageClassSpec
    permissions: Optional[StorageClassPermissions] = None
    customization: Optional[StorageClassCustomization] = None
    __properties: ClassVar[List[str]] = [
        "clusterId",
        "storageClassName",
        "spec",
        "permissions",
        "customization",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageClassV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of spec
        if self.spec:
            _dict["spec"] = self.spec.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permissions
        if self.permissions:
            _dict["permissions"] = self.permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customization
        if self.customization:
            _dict["customization"] = self.customization.to_dict()
        # set to None if permissions (nullable) is None
        # and model_fields_set contains the field
        if self.permissions is None and "permissions" in self.model_fields_set:
            _dict["permissions"] = None

        # set to None if customization (nullable) is None
        # and model_fields_set contains the field
        if self.customization is None and "customization" in self.model_fields_set:
            _dict["customization"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageClassV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "clusterId": obj.get("clusterId"),
                "storageClassName": obj.get("storageClassName"),
                "spec": (
                    StorageClassSpec.from_dict(obj["spec"])
                    if obj.get("spec") is not None
                    else None
                ),
                "permissions": (
                    StorageClassPermissions.from_dict(obj["permissions"])
                    if obj.get("permissions") is not None
                    else None
                ),
                "customization": (
                    StorageClassCustomization.from_dict(obj["customization"])
                    if obj.get("customization") is not None
                    else None
                ),
            }
        )
        return _obj
