# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from runai.models.storage_class_v2 import StorageClassV2
from typing import Optional, Set
from typing_extensions import Self


class StorageClassesV2(BaseModel):
    """
    Pydantic class model representing StorageClassesV2.

    Parameters:
        ```python
        items: List[StorageClassV2]
        ```
        items: See model List[StorageClassV2] for more information.
    Example:
        ```python
        StorageClassesV2(
            items=[
                    runai.models.storage_class_v2.StorageClassV2(
                        cluster_id = '550e8400-e29b-41d4-a716-446655440000',
                        storage_class_name = 'my-storage-class',
                        spec = runai.models.storage_class_spec.StorageClassSpec(
                            provisioner = 'kubernetes.io/aws-ebs',
                            allow_volume_expansion = True,
                            is_default = False, ),
                        permissions = runai.models.storage_class_permissions.StorageClassPermissions(
                            allowed_for_assets = True,
                            allowed_for_workloads = True,
                            allowed_for_ephemeral_volumes = True,
                            allowed_for_persistent_volumes = True,
                            allow_data_sharing = True, ),
                        customization = runai.models.storage_class_customization.StorageClassCustomization(
                            access_mode = runai.models.access_mode_customization.AccessModeCustomization(
                                required = True,
                                default = runai.models.pvc_access_modes.PvcAccessModes(
                                    read_write_once = True,
                                    read_only_many = True,
                                    read_write_many = True, ),
                                supported_values = runai.models.pvc_supported_access_modes.PvcSupportedAccessModes(
                                    read_write_once = True,
                                    read_only_many = True,
                                    read_write_many = True, ), ),
                            volume_mode = runai.models.volume_mode_customization.VolumeModeCustomization(
                                required = True, ),
                            claim_size = runai.models.claim_size_customization.ClaimSizeCustomization(
                                supported_units = [
                                    'MB'
                                    ],
                                min = '1G',
                                max = '1G',
                                step = '1G', ),
                            attributes = [
                                runai.models.pvc_added_attribute.PvcAddedAttribute(
                                    key = 'dnsname',
                                    format = 'text',
                                    display = 'DNS Name',
                                    description = 'The host name of the DNS',
                                    placeholder = 'enter hostname or IP address',
                                    required = True,
                                    default_value = 'my.dns.com',
                                    validation_regexp = '^[a-zA-Z0-9.-_]+$',
                                    min_value = 100,
                                    max_value = 200,
                                    step = 5,
                                    validation_error = 'Invalid URL', )
                                ], ), )
                    ]
        )
        ```
    """  # noqa: E501

    items: List[StorageClassV2]
    __properties: ClassVar[List[str]] = ["items"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageClassesV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict["items"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageClassesV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "items": (
                    [StorageClassV2.from_dict(_item) for _item in obj["items"]]
                    if obj.get("items") is not None
                    else None
                )
            }
        )
        return _obj
