# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.config_maps_defaults import ConfigMapsDefaults
from runai.models.data_volumes_defaults import DataVolumesDefaults
from runai.models.empty_dirs_defaults import EmptyDirsDefaults
from runai.models.gits_defaults import GitsDefaults
from runai.models.host_paths_defaults import HostPathsDefaults
from runai.models.nfss_defaults import NfssDefaults
from runai.models.pvcs_defaults import PvcsDefaults
from runai.models.s3s_defaults import S3sDefaults
from runai.models.secrets_defaults import SecretsDefaults
from typing import Optional, Set
from typing_extensions import Self


class StorageFieldsDefaults(BaseModel):
    """
    Pydantic class model representing StorageFieldsDefaults.

    Parameters:
        ```python
        data_volume: Optional[DataVolumesDefaults]
        pvc: Optional[PvcsDefaults]
        host_path: Optional[HostPathsDefaults]
        nfs: Optional[NfssDefaults]
        git: Optional[GitsDefaults]
        config_map_volume: Optional[ConfigMapsDefaults]
        secret_volume: Optional[SecretsDefaults]
        empty_dir_volume: Optional[EmptyDirsDefaults]
        s3: Optional[S3sDefaults]
        ```
        data_volume: See model DataVolumesDefaults for more information.
        pvc: See model PvcsDefaults for more information.
        host_path: See model HostPathsDefaults for more information.
        nfs: See model NfssDefaults for more information.
        git: See model GitsDefaults for more information.
        config_map_volume: See model ConfigMapsDefaults for more information.
        secret_volume: See model SecretsDefaults for more information.
        empty_dir_volume: See model EmptyDirsDefaults for more information.
        s3: See model S3sDefaults for more information.
    Example:
        ```python
        StorageFieldsDefaults(
            data_volume=runai.models.data_volumes_defaults.DataVolumesDefaults(
                    attributes = runai.models.data_volume_instance.DataVolumeInstance(),
                    instances = [
                        runai.models.data_volume_instance.DataVolumeInstance()
                        ], ),
                        pvc=runai.models.pvcs_defaults.PvcsDefaults(
                    attributes = runai.models.pvc_instance.PvcInstance(),
                    instances = [
                        runai.models.pvc_instance.PvcInstance()
                        ], ),
                        host_path=runai.models.host_paths_defaults.HostPathsDefaults(
                    attributes = runai.models.host_path_instance.HostPathInstance(),
                    instances = [
                        runai.models.host_path_instance.HostPathInstance()
                        ], ),
                        nfs=runai.models.nfss_defaults.NfssDefaults(
                    attributes = runai.models.nfs_instance.NfsInstance(),
                    instances = [
                        runai.models.nfs_instance.NfsInstance()
                        ], ),
                        git=runai.models.gits_defaults.GitsDefaults(
                    attributes = runai.models.git_instance.GitInstance(),
                    instances = [
                        runai.models.git_instance.GitInstance()
                        ], ),
                        config_map_volume=runai.models.config_maps_defaults.ConfigMapsDefaults(
                    attributes = runai.models.config_map_instance.ConfigMapInstance(),
                    instances = [
                        runai.models.config_map_instance.ConfigMapInstance()
                        ], ),
                        secret_volume=runai.models.secrets_defaults.SecretsDefaults(
                    attributes = runai.models.secret_instance2.SecretInstance2(),
                    instances = [
                        runai.models.secret_instance2.SecretInstance2()
                        ], ),
                        empty_dir_volume=runai.models.empty_dirs_defaults.EmptyDirsDefaults(
                    attributes = runai.models.empty_dir_instance.EmptyDirInstance(),
                    instances = [
                        runai.models.empty_dir_instance.EmptyDirInstance()
                        ], ),
                        s3=runai.models.s3s_defaults.S3sDefaults(
                    attributes = runai.models.s3_instance.S3Instance(),
                    instances = [
                        runai.models.s3_instance.S3Instance()
                        ], )
        )
        ```
    """  # noqa: E501

    data_volume: Optional[DataVolumesDefaults] = Field(default=None, alias="dataVolume")
    pvc: Optional[PvcsDefaults] = None
    host_path: Optional[HostPathsDefaults] = Field(default=None, alias="hostPath")
    nfs: Optional[NfssDefaults] = None
    git: Optional[GitsDefaults] = None
    config_map_volume: Optional[ConfigMapsDefaults] = Field(
        default=None, alias="configMapVolume"
    )
    secret_volume: Optional[SecretsDefaults] = Field(default=None, alias="secretVolume")
    empty_dir_volume: Optional[EmptyDirsDefaults] = Field(
        default=None, alias="emptyDirVolume"
    )
    s3: Optional[S3sDefaults] = None
    __properties: ClassVar[List[str]] = [
        "dataVolume",
        "pvc",
        "hostPath",
        "nfs",
        "git",
        "configMapVolume",
        "secretVolume",
        "emptyDirVolume",
        "s3",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageFieldsDefaults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_volume
        if self.data_volume:
            _dict["dataVolume"] = self.data_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pvc
        if self.pvc:
            _dict["pvc"] = self.pvc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of host_path
        if self.host_path:
            _dict["hostPath"] = self.host_path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nfs
        if self.nfs:
            _dict["nfs"] = self.nfs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git
        if self.git:
            _dict["git"] = self.git.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_map_volume
        if self.config_map_volume:
            _dict["configMapVolume"] = self.config_map_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secret_volume
        if self.secret_volume:
            _dict["secretVolume"] = self.secret_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of empty_dir_volume
        if self.empty_dir_volume:
            _dict["emptyDirVolume"] = self.empty_dir_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of s3
        if self.s3:
            _dict["s3"] = self.s3.to_dict()
        # set to None if data_volume (nullable) is None
        # and model_fields_set contains the field
        if self.data_volume is None and "data_volume" in self.model_fields_set:
            _dict["dataVolume"] = None

        # set to None if pvc (nullable) is None
        # and model_fields_set contains the field
        if self.pvc is None and "pvc" in self.model_fields_set:
            _dict["pvc"] = None

        # set to None if host_path (nullable) is None
        # and model_fields_set contains the field
        if self.host_path is None and "host_path" in self.model_fields_set:
            _dict["hostPath"] = None

        # set to None if nfs (nullable) is None
        # and model_fields_set contains the field
        if self.nfs is None and "nfs" in self.model_fields_set:
            _dict["nfs"] = None

        # set to None if git (nullable) is None
        # and model_fields_set contains the field
        if self.git is None and "git" in self.model_fields_set:
            _dict["git"] = None

        # set to None if config_map_volume (nullable) is None
        # and model_fields_set contains the field
        if (
            self.config_map_volume is None
            and "config_map_volume" in self.model_fields_set
        ):
            _dict["configMapVolume"] = None

        # set to None if secret_volume (nullable) is None
        # and model_fields_set contains the field
        if self.secret_volume is None and "secret_volume" in self.model_fields_set:
            _dict["secretVolume"] = None

        # set to None if empty_dir_volume (nullable) is None
        # and model_fields_set contains the field
        if (
            self.empty_dir_volume is None
            and "empty_dir_volume" in self.model_fields_set
        ):
            _dict["emptyDirVolume"] = None

        # set to None if s3 (nullable) is None
        # and model_fields_set contains the field
        if self.s3 is None and "s3" in self.model_fields_set:
            _dict["s3"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageFieldsDefaults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "dataVolume": (
                    DataVolumesDefaults.from_dict(obj["dataVolume"])
                    if obj.get("dataVolume") is not None
                    else None
                ),
                "pvc": (
                    PvcsDefaults.from_dict(obj["pvc"])
                    if obj.get("pvc") is not None
                    else None
                ),
                "hostPath": (
                    HostPathsDefaults.from_dict(obj["hostPath"])
                    if obj.get("hostPath") is not None
                    else None
                ),
                "nfs": (
                    NfssDefaults.from_dict(obj["nfs"])
                    if obj.get("nfs") is not None
                    else None
                ),
                "git": (
                    GitsDefaults.from_dict(obj["git"])
                    if obj.get("git") is not None
                    else None
                ),
                "configMapVolume": (
                    ConfigMapsDefaults.from_dict(obj["configMapVolume"])
                    if obj.get("configMapVolume") is not None
                    else None
                ),
                "secretVolume": (
                    SecretsDefaults.from_dict(obj["secretVolume"])
                    if obj.get("secretVolume") is not None
                    else None
                ),
                "emptyDirVolume": (
                    EmptyDirsDefaults.from_dict(obj["emptyDirVolume"])
                    if obj.get("emptyDirVolume") is not None
                    else None
                ),
                "s3": (
                    S3sDefaults.from_dict(obj["s3"])
                    if obj.get("s3") is not None
                    else None
                ),
            }
        )
        return _obj
