# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.config_maps_rules import ConfigMapsRules
from runai.models.data_volumes_rules import DataVolumesRules
from runai.models.empty_dirs_rules import EmptyDirsRules
from runai.models.gits_rules import GitsRules
from runai.models.host_paths_rules import HostPathsRules
from runai.models.nfss_rules import NfssRules
from runai.models.pvcs_rules import PvcsRules
from runai.models.s3s_rules import S3sRules
from runai.models.secrets_rules import SecretsRules
from typing import Optional, Set
from typing_extensions import Self


class StorageFieldsRules(BaseModel):
    """
    Pydantic class model representing StorageFieldsRules.

    Parameters:
        ```python
        data_volume: Optional[DataVolumesRules]
        pvc: Optional[PvcsRules]
        host_path: Optional[HostPathsRules]
        nfs: Optional[NfssRules]
        git: Optional[GitsRules]
        config_map_volume: Optional[ConfigMapsRules]
        secret_volume: Optional[SecretsRules]
        empty_dir_volume: Optional[EmptyDirsRules]
        s3: Optional[S3sRules]
        ```
        data_volume: See model DataVolumesRules for more information.
        pvc: See model PvcsRules for more information.
        host_path: See model HostPathsRules for more information.
        nfs: See model NfssRules for more information.
        git: See model GitsRules for more information.
        config_map_volume: See model ConfigMapsRules for more information.
        secret_volume: See model SecretsRules for more information.
        empty_dir_volume: See model EmptyDirsRules for more information.
        s3: See model S3sRules for more information.
    Example:
        ```python
        StorageFieldsRules(
            data_volume=runai.models.data_volumes_rules.DataVolumesRules(
                    attributes = runai.models.data_volume_rules.DataVolumeRules(
                        id = runai.models.string_rules.StringRules(),
                        mount_path = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        pvc=runai.models.pvcs_rules.PvcsRules(
                    attributes = runai.models.pvc_rules.PvcRules(
                        claim_name = runai.models.string_rules.StringRules(),
                        path = runai.models.string_rules.StringRules(),
                        read_only = runai.models.boolean_rules.BooleanRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True, ),
                        claim_info = runai.models.claim_info_rules.ClaimInfoRules(
                            size = runai.models.string_rules.StringRules(),
                            storage_class = runai.models.string_rules.StringRules(),
                            access_modes = runai.models.pvc_access_modes_rules.PvcAccessModesRules(
                                read_write_once = runai.models.boolean_rules.BooleanRules(
                                    required = True,
                                    can_edit = True, ),
                                read_only_many = ,
                                read_write_many = , ), ), ),
                    instances = runai.models.item_rules.ItemRules(
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        host_path=runai.models.host_paths_rules.HostPathsRules(
                    attributes = runai.models.host_path_rules.HostPathRules(
                        path = runai.models.string_rules.StringRules(),
                        read_only = runai.models.boolean_rules.BooleanRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True, ),
                        mount_path = runai.models.string_rules.StringRules(),
                        mount_propagation = runai.models.host_path_mount_propagation_rules.HostPathMountPropagationRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        nfs=runai.models.nfss_rules.NfssRules(
                    attributes = runai.models.nfs_rules.NfsRules(
                        path = runai.models.string_rules.StringRules(),
                        read_only = runai.models.boolean_rules.BooleanRules(
                            source_of_rule = {"scope":"project","projectId":3},
                            required = True,
                            can_edit = True, ),
                        server = runai.models.string_rules.StringRules(),
                        mount_path = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        git=runai.models.gits_rules.GitsRules(
                    attributes = runai.models.git_rules.GitRules(
                        repository = runai.models.string_rules.StringRules(),
                        branch = runai.models.string_rules.StringRules(),
                        revision = runai.models.string_rules.StringRules(),
                        path = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        config_map_volume=runai.models.config_maps_rules.ConfigMapsRules(
                    attributes = runai.models.config_map_rules.ConfigMapRules(
                        config_map = runai.models.string_rules.StringRules(),
                        mount_path = runai.models.string_rules.StringRules(),
                        sub_path = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        secret_volume=runai.models.secrets_rules.SecretsRules(
                    attributes = runai.models.secret_rules.SecretRules(
                        secret = runai.models.string_rules.StringRules(),
                        mount_path = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        empty_dir_volume=runai.models.empty_dirs_rules.EmptyDirsRules(
                    attributes = runai.models.empty_dir_rules.EmptyDirRules(
                        path = runai.models.string_rules.StringRules(),
                        medium = runai.models.string_rules.StringRules(),
                        size_limit = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), ),
                        s3=runai.models.s3s_rules.S3sRules(
                    attributes = runai.models.s3_rules.S3Rules(
                        bucket = runai.models.string_rules.StringRules(),
                        path = runai.models.string_rules.StringRules(),
                        url = runai.models.string_rules.StringRules(), ),
                    instances = runai.models.item_rules.ItemRules(
                        source_of_rule = {"scope":"project","projectId":3},
                        can_add = True,
                        locked = ["HOME","USER"], ), )
        )
        ```
    """  # noqa: E501

    data_volume: Optional[DataVolumesRules] = Field(default=None, alias="dataVolume")
    pvc: Optional[PvcsRules] = None
    host_path: Optional[HostPathsRules] = Field(default=None, alias="hostPath")
    nfs: Optional[NfssRules] = None
    git: Optional[GitsRules] = None
    config_map_volume: Optional[ConfigMapsRules] = Field(
        default=None, alias="configMapVolume"
    )
    secret_volume: Optional[SecretsRules] = Field(default=None, alias="secretVolume")
    empty_dir_volume: Optional[EmptyDirsRules] = Field(
        default=None, alias="emptyDirVolume"
    )
    s3: Optional[S3sRules] = None
    __properties: ClassVar[List[str]] = [
        "dataVolume",
        "pvc",
        "hostPath",
        "nfs",
        "git",
        "configMapVolume",
        "secretVolume",
        "emptyDirVolume",
        "s3",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageFieldsRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_volume
        if self.data_volume:
            _dict["dataVolume"] = self.data_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pvc
        if self.pvc:
            _dict["pvc"] = self.pvc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of host_path
        if self.host_path:
            _dict["hostPath"] = self.host_path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nfs
        if self.nfs:
            _dict["nfs"] = self.nfs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git
        if self.git:
            _dict["git"] = self.git.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config_map_volume
        if self.config_map_volume:
            _dict["configMapVolume"] = self.config_map_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secret_volume
        if self.secret_volume:
            _dict["secretVolume"] = self.secret_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of empty_dir_volume
        if self.empty_dir_volume:
            _dict["emptyDirVolume"] = self.empty_dir_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of s3
        if self.s3:
            _dict["s3"] = self.s3.to_dict()
        # set to None if data_volume (nullable) is None
        # and model_fields_set contains the field
        if self.data_volume is None and "data_volume" in self.model_fields_set:
            _dict["dataVolume"] = None

        # set to None if pvc (nullable) is None
        # and model_fields_set contains the field
        if self.pvc is None and "pvc" in self.model_fields_set:
            _dict["pvc"] = None

        # set to None if host_path (nullable) is None
        # and model_fields_set contains the field
        if self.host_path is None and "host_path" in self.model_fields_set:
            _dict["hostPath"] = None

        # set to None if nfs (nullable) is None
        # and model_fields_set contains the field
        if self.nfs is None and "nfs" in self.model_fields_set:
            _dict["nfs"] = None

        # set to None if git (nullable) is None
        # and model_fields_set contains the field
        if self.git is None and "git" in self.model_fields_set:
            _dict["git"] = None

        # set to None if config_map_volume (nullable) is None
        # and model_fields_set contains the field
        if (
            self.config_map_volume is None
            and "config_map_volume" in self.model_fields_set
        ):
            _dict["configMapVolume"] = None

        # set to None if secret_volume (nullable) is None
        # and model_fields_set contains the field
        if self.secret_volume is None and "secret_volume" in self.model_fields_set:
            _dict["secretVolume"] = None

        # set to None if empty_dir_volume (nullable) is None
        # and model_fields_set contains the field
        if (
            self.empty_dir_volume is None
            and "empty_dir_volume" in self.model_fields_set
        ):
            _dict["emptyDirVolume"] = None

        # set to None if s3 (nullable) is None
        # and model_fields_set contains the field
        if self.s3 is None and "s3" in self.model_fields_set:
            _dict["s3"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageFieldsRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "dataVolume": (
                    DataVolumesRules.from_dict(obj["dataVolume"])
                    if obj.get("dataVolume") is not None
                    else None
                ),
                "pvc": (
                    PvcsRules.from_dict(obj["pvc"])
                    if obj.get("pvc") is not None
                    else None
                ),
                "hostPath": (
                    HostPathsRules.from_dict(obj["hostPath"])
                    if obj.get("hostPath") is not None
                    else None
                ),
                "nfs": (
                    NfssRules.from_dict(obj["nfs"])
                    if obj.get("nfs") is not None
                    else None
                ),
                "git": (
                    GitsRules.from_dict(obj["git"])
                    if obj.get("git") is not None
                    else None
                ),
                "configMapVolume": (
                    ConfigMapsRules.from_dict(obj["configMapVolume"])
                    if obj.get("configMapVolume") is not None
                    else None
                ),
                "secretVolume": (
                    SecretsRules.from_dict(obj["secretVolume"])
                    if obj.get("secretVolume") is not None
                    else None
                ),
                "emptyDirVolume": (
                    EmptyDirsRules.from_dict(obj["emptyDirVolume"])
                    if obj.get("emptyDirVolume") is not None
                    else None
                ),
                "s3": (
                    S3sRules.from_dict(obj["s3"]) if obj.get("s3") is not None else None
                ),
            }
        )
        return _obj
