# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class SuperSetServingPort(BaseModel):
    """
    Pydantic class model representing SuperSetServingPort.

    Parameters:
        ```python
        port: Optional[int]
        container: Optional[int]
        protocol: Optional[str]
        authorization_type: Optional[str]
        authorized_users: Optional[List[str]]
        authorized_groups: Optional[List[str]]
        cluster_local_access_only: Optional[bool]
        expose_externally: Optional[bool]
        exposed_url: Optional[str]
        ```
        port: See model int for more information.
        container: See model int for more information.
        protocol: See model str for more information.
        authorization_type: See model str for more information.
        authorized_users: See model List[str] for more information.
        authorized_groups: See model List[str] for more information.
        cluster_local_access_only: See model bool for more information.
        expose_externally: See model bool for more information.
        exposed_url: See model str for more information.
    Example:
        ```python
        SuperSetServingPort(
            port=56,
                        container=56,
                        protocol='',
                        authorization_type='',
                        authorized_users=[
                    ''
                    ],
                        authorized_groups=[
                    ''
                    ],
                        cluster_local_access_only=True,
                        expose_externally=True,
                        exposed_url=''
        )
        ```
    """  # noqa: E501

    port: Optional[StrictInt] = None
    container: Optional[StrictInt] = None
    protocol: Optional[StrictStr] = None
    authorization_type: Optional[StrictStr] = Field(
        default=None, alias="authorizationType"
    )
    authorized_users: Optional[List[StrictStr]] = Field(
        default=None, alias="authorizedUsers"
    )
    authorized_groups: Optional[List[StrictStr]] = Field(
        default=None, alias="authorizedGroups"
    )
    cluster_local_access_only: Optional[StrictBool] = Field(
        default=None, alias="clusterLocalAccessOnly"
    )
    expose_externally: Optional[StrictBool] = Field(
        default=None, alias="exposeExternally"
    )
    exposed_url: Optional[StrictStr] = Field(default=None, alias="exposedUrl")
    __properties: ClassVar[List[str]] = [
        "port",
        "container",
        "protocol",
        "authorizationType",
        "authorizedUsers",
        "authorizedGroups",
        "clusterLocalAccessOnly",
        "exposeExternally",
        "exposedUrl",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SuperSetServingPort from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if port (nullable) is None
        # and model_fields_set contains the field
        if self.port is None and "port" in self.model_fields_set:
            _dict["port"] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict["container"] = None

        # set to None if protocol (nullable) is None
        # and model_fields_set contains the field
        if self.protocol is None and "protocol" in self.model_fields_set:
            _dict["protocol"] = None

        # set to None if authorization_type (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorization_type is None
            and "authorization_type" in self.model_fields_set
        ):
            _dict["authorizationType"] = None

        # set to None if authorized_users (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_users is None
            and "authorized_users" in self.model_fields_set
        ):
            _dict["authorizedUsers"] = None

        # set to None if authorized_groups (nullable) is None
        # and model_fields_set contains the field
        if (
            self.authorized_groups is None
            and "authorized_groups" in self.model_fields_set
        ):
            _dict["authorizedGroups"] = None

        # set to None if cluster_local_access_only (nullable) is None
        # and model_fields_set contains the field
        if (
            self.cluster_local_access_only is None
            and "cluster_local_access_only" in self.model_fields_set
        ):
            _dict["clusterLocalAccessOnly"] = None

        # set to None if expose_externally (nullable) is None
        # and model_fields_set contains the field
        if (
            self.expose_externally is None
            and "expose_externally" in self.model_fields_set
        ):
            _dict["exposeExternally"] = None

        # set to None if exposed_url (nullable) is None
        # and model_fields_set contains the field
        if self.exposed_url is None and "exposed_url" in self.model_fields_set:
            _dict["exposedUrl"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SuperSetServingPort from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "port": obj.get("port"),
                "container": obj.get("container"),
                "protocol": obj.get("protocol"),
                "authorizationType": obj.get("authorizationType"),
                "authorizedUsers": obj.get("authorizedUsers"),
                "authorizedGroups": obj.get("authorizedGroups"),
                "clusterLocalAccessOnly": obj.get("clusterLocalAccessOnly"),
                "exposeExternally": obj.get("exposeExternally"),
                "exposedUrl": obj.get("exposedUrl"),
            }
        )
        return _obj
