# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from runai.models.scope_type import ScopeType
from runai.models.workload_type import WorkloadType
from typing import Optional, Set
from typing_extensions import Self


class TemplateMetaFields(BaseModel):
    """
    Pydantic class model representing TemplateMetaFields.

    Parameters:
        ```python
        id: str
        name: str
        description: Optional[str]
        workload_type: WorkloadType
        scope_type: ScopeType
        scope_id: str
        cluster_id: Optional[str]
        department_id: Optional[str]
        project_id: Optional[int]
        created_by: str
        created_at: datetime
        updated_by: Optional[str]
        updated_at: Optional[datetime]
        ```
        id: A unique ID of the template.
        name: The name of the template.
        description: A description of the template.
        workload_type: See model WorkloadType for more information.
        scope_type: See model ScopeType for more information.
        scope_id: The id of the cluster, department or project, depending on the scope type.
        cluster_id: The id of the cluster.
        department_id: The id of the department.
        project_id: The id of the project.
        created_by: The user who created the template
        created_at: The creation time of the template.
        updated_by: The user who recently updated the template
        updated_at: The time of the recent update.
    Example:
        ```python
        TemplateMetaFields(
            id='550e8400-e29b-41d4-a716-446655440000',
                        name='my-template-name',
                        description='description of my template.',
                        workload_type='Workspace',
                        scope_type='system',
                        scope_id='',
                        cluster_id='71f69d83-ba66-4822-adf5-55ce55efd210',
                        department_id='2',
                        project_id=1,
                        created_by='test@lab.com',
                        created_at='2022-01-01T03:49:52.531Z',
                        updated_by='test@lab.com',
                        updated_at='2022-01-01T03:49:52.531Z'
        )
        ```
    """  # noqa: E501

    id: StrictStr = Field(description="A unique ID of the template.")
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(
        description="The name of the template."
    )
    description: Optional[
        Annotated[str, Field(min_length=1, strict=True, max_length=250)]
    ] = Field(default=None, description="A description of the template.")
    workload_type: WorkloadType = Field(alias="workloadType")
    scope_type: ScopeType = Field(alias="scopeType")
    scope_id: StrictStr = Field(
        description="The id of the cluster, department or project, depending on the scope type.",
        alias="scopeId",
    )
    cluster_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="The id of the cluster.", alias="clusterId"
    )
    department_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(
        default=None, description="The id of the department.", alias="departmentId"
    )
    project_id: Optional[StrictInt] = Field(
        default=None, description="The id of the project.", alias="projectId"
    )
    created_by: StrictStr = Field(
        description="The user who created the template", alias="createdBy"
    )
    created_at: datetime = Field(
        description="The creation time of the template.", alias="createdAt"
    )
    updated_by: Optional[StrictStr] = Field(
        default=None,
        description="The user who recently updated the template",
        alias="updatedBy",
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The time of the recent update.", alias="updatedAt"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "description",
        "workloadType",
        "scopeType",
        "scopeId",
        "clusterId",
        "departmentId",
        "projectId",
        "createdBy",
        "createdAt",
        "updatedBy",
        "updatedAt",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TemplateMetaFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        # set to None if cluster_id (nullable) is None
        # and model_fields_set contains the field
        if self.cluster_id is None and "cluster_id" in self.model_fields_set:
            _dict["clusterId"] = None

        # set to None if department_id (nullable) is None
        # and model_fields_set contains the field
        if self.department_id is None and "department_id" in self.model_fields_set:
            _dict["departmentId"] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict["projectId"] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict["updatedBy"] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict["updatedAt"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TemplateMetaFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "description": obj.get("description"),
                "workloadType": obj.get("workloadType"),
                "scopeType": obj.get("scopeType"),
                "scopeId": obj.get("scopeId"),
                "clusterId": obj.get("clusterId"),
                "departmentId": obj.get("departmentId"),
                "projectId": obj.get("projectId"),
                "createdBy": obj.get("createdBy"),
                "createdAt": obj.get("createdAt"),
                "updatedBy": obj.get("updatedBy"),
                "updatedAt": obj.get("updatedAt"),
            }
        )
        return _obj
