# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from runai.models.boolean_rules import BooleanRules
from runai.models.integer_rules import IntegerRules
from runai.models.string_rules import StringRules
from runai.models.toleration_effect_rules import TolerationEffectRules
from runai.models.toleration_operator_rules import TolerationOperatorRules
from typing import Optional, Set
from typing_extensions import Self


class TolerationRules(BaseModel):
    """
    Pydantic class model representing Toleration details..

    Parameters:
        ```python
        operator: Optional[TolerationOperatorRules]
        key: Optional[StringRules]
        value: Optional[StringRules]
        effect: Optional[TolerationEffectRules]
        seconds: Optional[IntegerRules]
        exclude: Optional[BooleanRules]
        ```
        operator: See model TolerationOperatorRules for more information.
        key: See model StringRules for more information.
        value: See model StringRules for more information.
        effect: See model TolerationEffectRules for more information.
        seconds: See model IntegerRules for more information.
        exclude: See model BooleanRules for more information.
    Example:
        ```python
        TolerationRules(
            operator=runai.models.toleration_operator_rules.TolerationOperatorRules(),
                        key=runai.models.string_rules.StringRules(),
                        value=runai.models.string_rules.StringRules(),
                        effect=runai.models.toleration_effect_rules.TolerationEffectRules(),
                        seconds=runai.models.integer_rules.IntegerRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True,
                    min = 56,
                    max = 56,
                    step = 56,
                    default_from = runai.models.default_from_rule.DefaultFromRule(
                        field = '',
                        factor = 1.337, ), ),
                        exclude=runai.models.boolean_rules.BooleanRules(
                    source_of_rule = {"scope":"project","projectId":3},
                    required = True,
                    can_edit = True, )
        )
        ```
    """  # noqa: E501

    operator: Optional[TolerationOperatorRules] = None
    key: Optional[StringRules] = None
    value: Optional[StringRules] = None
    effect: Optional[TolerationEffectRules] = None
    seconds: Optional[IntegerRules] = None
    exclude: Optional[BooleanRules] = None
    __properties: ClassVar[List[str]] = [
        "operator",
        "key",
        "value",
        "effect",
        "seconds",
        "exclude",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TolerationRules from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of operator
        if self.operator:
            _dict["operator"] = self.operator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of key
        if self.key:
            _dict["key"] = self.key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of value
        if self.value:
            _dict["value"] = self.value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of effect
        if self.effect:
            _dict["effect"] = self.effect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of seconds
        if self.seconds:
            _dict["seconds"] = self.seconds.to_dict()
        # override the default output from pydantic by calling `to_dict()` of exclude
        if self.exclude:
            _dict["exclude"] = self.exclude.to_dict()
        # set to None if operator (nullable) is None
        # and model_fields_set contains the field
        if self.operator is None and "operator" in self.model_fields_set:
            _dict["operator"] = None

        # set to None if key (nullable) is None
        # and model_fields_set contains the field
        if self.key is None and "key" in self.model_fields_set:
            _dict["key"] = None

        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict["value"] = None

        # set to None if effect (nullable) is None
        # and model_fields_set contains the field
        if self.effect is None and "effect" in self.model_fields_set:
            _dict["effect"] = None

        # set to None if seconds (nullable) is None
        # and model_fields_set contains the field
        if self.seconds is None and "seconds" in self.model_fields_set:
            _dict["seconds"] = None

        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict["exclude"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TolerationRules from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "operator": (
                    TolerationOperatorRules.from_dict(obj["operator"])
                    if obj.get("operator") is not None
                    else None
                ),
                "key": (
                    StringRules.from_dict(obj["key"])
                    if obj.get("key") is not None
                    else None
                ),
                "value": (
                    StringRules.from_dict(obj["value"])
                    if obj.get("value") is not None
                    else None
                ),
                "effect": (
                    TolerationEffectRules.from_dict(obj["effect"])
                    if obj.get("effect") is not None
                    else None
                ),
                "seconds": (
                    IntegerRules.from_dict(obj["seconds"])
                    if obj.get("seconds") is not None
                    else None
                ),
                "exclude": (
                    BooleanRules.from_dict(obj["exclude"])
                    if obj.get("exclude") is not None
                    else None
                ),
            }
        )
        return _obj
