# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self


class TotalResources(BaseModel):
    """
    Pydantic class model representing TotalResources.

    Parameters:
        ```python
        gpu_quota: Optional[float]
        cpu_quota: Optional[float]
        memory_quota: Optional[float]
        ```
        gpu_quota: Total gpu quota of the org unit
        cpu_quota: Total cpu quota of the org unit in Millicores
        memory_quota: Total memory quota of the org unit in MB
    Example:
        ```python
        TotalResources(
            gpu_quota=1.337,
                        cpu_quota=1.337,
                        memory_quota=1.337
        )
        ```
    """  # noqa: E501

    gpu_quota: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Total gpu quota of the org unit", alias="gpuQuota"
    )
    cpu_quota: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Total cpu quota of the org unit in Millicores",
        alias="cpuQuota",
    )
    memory_quota: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Total memory quota of the org unit in MB",
        alias="memoryQuota",
    )
    __properties: ClassVar[List[str]] = ["gpuQuota", "cpuQuota", "memoryQuota"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TotalResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if gpu_quota (nullable) is None
        # and model_fields_set contains the field
        if self.gpu_quota is None and "gpu_quota" in self.model_fields_set:
            _dict["gpuQuota"] = None

        # set to None if cpu_quota (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_quota is None and "cpu_quota" in self.model_fields_set:
            _dict["cpuQuota"] = None

        # set to None if memory_quota (nullable) is None
        # and model_fields_set contains the field
        if self.memory_quota is None and "memory_quota" in self.model_fields_set:
            _dict["memoryQuota"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TotalResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "gpuQuota": obj.get("gpuQuota"),
                "cpuQuota": obj.get("cpuQuota"),
                "memoryQuota": obj.get("memoryQuota"),
            }
        )
        return _obj
