# coding: utf-8

"""
NVIDIA Run:ai

# Introduction  The NVIDIA Run:ai Control-Plane API reference is a guide that provides an easy-to-use programming interface for adding various tasks to your application, including workload submission, resource management, and administrative operations.  NVIDIA Run:ai APIs are accessed using *bearer tokens*. To obtain a token, you need to create an **Application** through the NVIDIA Run:ai user interface. To create an application, in your UI, go to `Settings & Tools`, `Application` and create a new Application.  After you have created a new application, you will need to assign it access rules. To assign access rules to the application, see [Create access rules](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/accessrules#create-or-delete-rules). Make sure you assign the correct rules to your application. Use the [Roles](https://run-ai-docs.nvidia.com/saas/infrastructure-setup/authentication/roles) to assign the correct access rules.  To get your access token, follow the instructions in [Request a token](https://run-ai-docs.nvidia.com/saas/reference/api/rest-auth/#request-an-api-token).

The version of the OpenAPI document: latest
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class WorkloadMetricType(str, Enum):
    """
    Specify which metric data to request.

    Allowed enum values:

    GPU_UTILIZATION = 'GPU_UTILIZATION'

    GPU_MEMORY_USAGE_BYTES = 'GPU_MEMORY_USAGE_BYTES'

    GPU_MEMORY_REQUEST_BYTES = 'GPU_MEMORY_REQUEST_BYTES'

    CPU_USAGE_CORES = 'CPU_USAGE_CORES'

    CPU_REQUEST_CORES = 'CPU_REQUEST_CORES'

    CPU_LIMIT_CORES = 'CPU_LIMIT_CORES'

    CPU_MEMORY_USAGE_BYTES = 'CPU_MEMORY_USAGE_BYTES'

    CPU_MEMORY_REQUEST_BYTES = 'CPU_MEMORY_REQUEST_BYTES'

    CPU_MEMORY_LIMIT_BYTES = 'CPU_MEMORY_LIMIT_BYTES'

    POD_COUNT = 'POD_COUNT'

    RUNNING_POD_COUNT = 'RUNNING_POD_COUNT'

    GPU_ALLOCATION = 'GPU_ALLOCATION'


    Example:
        ```python
        WorkloadMetricType.GPU_UTILIZATION
        WorkloadMetricType.GPU_MEMORY_USAGE_BYTES
        WorkloadMetricType.GPU_MEMORY_REQUEST_BYTES
        WorkloadMetricType.CPU_USAGE_CORES
        WorkloadMetricType.CPU_REQUEST_CORES
        WorkloadMetricType.CPU_LIMIT_CORES
        WorkloadMetricType.CPU_MEMORY_USAGE_BYTES
        WorkloadMetricType.CPU_MEMORY_REQUEST_BYTES
        WorkloadMetricType.CPU_MEMORY_LIMIT_BYTES
        WorkloadMetricType.POD_COUNT
        WorkloadMetricType.RUNNING_POD_COUNT
        WorkloadMetricType.GPU_ALLOCATION
        ```
    """

    GPU_UTILIZATION = "GPU_UTILIZATION"
    GPU_MEMORY_USAGE_BYTES = "GPU_MEMORY_USAGE_BYTES"
    GPU_MEMORY_REQUEST_BYTES = "GPU_MEMORY_REQUEST_BYTES"
    CPU_USAGE_CORES = "CPU_USAGE_CORES"
    CPU_REQUEST_CORES = "CPU_REQUEST_CORES"
    CPU_LIMIT_CORES = "CPU_LIMIT_CORES"
    CPU_MEMORY_USAGE_BYTES = "CPU_MEMORY_USAGE_BYTES"
    CPU_MEMORY_REQUEST_BYTES = "CPU_MEMORY_REQUEST_BYTES"
    CPU_MEMORY_LIMIT_BYTES = "CPU_MEMORY_LIMIT_BYTES"
    POD_COUNT = "POD_COUNT"
    RUNNING_POD_COUNT = "RUNNING_POD_COUNT"
    GPU_ALLOCATION = "GPU_ALLOCATION"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of WorkloadMetricType from a JSON string"""
        return cls(json.loads(json_str))
