<div align="center"><img src="https://raw.githubusercontent.com/aistairc/aiaccel/master/docs/image/logo_aiaccel.png" width="600"/></div>
<div align="center">
    <img src="https://img.shields.io/github/license/aistairc/aiaccel.svg" />
    <img src="https://img.shields.io/badge/Python-3.10-blue" />
    <a href="https://aistairc.github.io/aiaccel">
        <img src="https://github.com/aistairc/aiaccel/actions/workflows/gh-pages.yaml/badge.svg" />
    </a>
    <img src="https://github.com/aistairc/aiaccel/actions/workflows/ci.yaml/badge.svg" />
</div>

# AIST Toolkit for Accelerating Machine Learning Research

* **Research-Oriented**: designed to accelerate your research cycles written in Python
* **HPC Optimized**: intended to use in HPC clusters, including [AI Bridging Cloud Infrastructure (ABCI)](https://abci.ai/)
* **Highly Modular**: designed to let you pick up any part of aiaccel for your research project

# Key Features
* [PyTorch/Lightning Toolkit](https://aistairc.github.io/aiaccel/api_reference/torch.html): training toolkit for HPC clusters.
* [Hyperparameter Optimization (HPO)](https://aistairc.github.io/aiaccel/api_reference/hpo.html): ready-to-use HPO algorithms/tools.
* [OmegaConf Utilities](https://aistairc.github.io/aiaccel/api_reference/config.html): OmegaConf-based config utilities.


# Installation
```bash
pip install aiaccel
```
       
# Acknowledgement
* Part of this software was developed in a project commissioned by the New Energy and Industrial Technology Development Organization (NEDO).
* Part of this software was developed by using ABCI 3.0 provided by AIST and AIST Solutions.
* Part of this software was developed by using the TSUBAME4.0 supercomputer at Institute of Science Tokyo.
