from typing import Any

from collections.abc import KeysView
from pathlib import Path
from types import TracebackType

# This stub is just for passing mypy.
class Dataset:
    def __setitem__(self, arg: Any, value: Any) -> None: ...
    def __getitem__(self, key: Any) -> Any: ...

class Group:
    def create_dataset(self, name: str, shape: Any | None = None, dtype: Any | None = None) -> Dataset: ...
    def __getitem__(self, name: Any) -> Dataset: ...
    def items(self) -> list[tuple[str, Any]]: ...

class File:
    def __init__(
        self,
        name: str | Path,
        mode: str = "r",
        driver: str | None = None,
        comm: Any | None = None,
    ) -> None: ...
    def __enter__(self) -> File: ...
    def __exit__(
        self,
        ex_exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
    ) -> bool: ...
    def keys(self) -> KeysView[str]: ...
    def __getitem__(self, key: str) -> Group | Dataset: ...
    def close(self) -> None: ...
    def create_group(self, name: str) -> Group: ...
