# PentestMCP

This is an MCP server developed as part of a **2-month** summer internship at KEYSTONE Group. This tool gives Large Language Models the ability to use active directory penetration testing tools. The goal is to save time, have the model analyze the result for you and gives you the juicy stuff and the most important thing (for me and for the lazy red teamers out there at least) is it documents findings for you, we all hate that.

## 🎯 Overview

The server provides a unified interface to tools like NetExec (CrackMapExec), Bloodhound, john, certipy and Nmap. This is an initial version that provides decent features but will always lack sufficient tools so if you're looking for something that is able to compromise an active directory environment from 0 to 100 that's not it and I dont think that it'll be possible without user guidance and interaction( at least for now !).
The MCP server was tested locally with Claude Desktop as the MCP client. It's important to note that I used Claude Desktop for Debian. For installation instructions, see: https://github.com/aaddrick/claude-desktop-debian 


## 🛠️ Requirements
The MCP server was developed using the amazing FastMCP: https://github.com/jlowin/fastmcp
### Core Dependencies
- **Python 3.8+** with UV package manager
- **NetExec** (successor to CrackMapExec)
- **Bloodhound Community Edition** 
- **Nmap**
- **Certipy**
- **psudohash** https://github.com/t3l3machus/psudohash for password list generation
- **john**
## 📦 Installation

### 1. Clone and Setup
```bash
git clone <repository-url>
cd PentestMCP

```

### 2. Install Required Tools

#### NetExec
```bash
# Via pipx (recommended)
pipx install netexec

# Or via pip
pip install netexec
```

#### Bloodhound Community Edition
```bash
# Download from official releases
wget https://github.com/SpecterOps/BloodHound/releases/latest/bloodhound-linux-x64.zip
unzip bloodhound-linux-x64.zip
# Follow BloodHound setup instructions
```

#### Nmap
```bash
# Ubuntu/Debian
sudo apt install nmap

# CentOS/RHEL
sudo yum install nmap
```

#### Certipy
```bash
pip install certipy-ad
```
#### John 
https://github.com/openwall/john/blob/bleeding-jumbo/doc/INSTALL


### 3. Configure MCP Client

#### For Claude Desktop

Add to your `~/.config/claude-desktop/config.json`:
```json
{
  "mcpServers": {
    "pentestmcp": {
      "command": "uv",
      "args": ["run", "python", "server.py"]
    }
  }
}
```
Don't forget to actually replace 'server.py' with the absolute path to the script.

#### For Other MCP Clients
Configure according to your client's documentation, pointing to `server.py` as the entry point.


## 🚀 Usage Examples
Before you run your MCP client: 
1. **Start bloodhound**
2. **configure `config.json` with your bloodhound api creds, prject directory to save findings in etc**

### Example Workflow

1. **Start with Network Discovery**
```
"Scan the network 192.168.1.0/24 for SMB services and check signing status"
```

2. **Enumerate Users**
```
"Find all users in the domain at 192.168.1.10"
```

3. **Credential Attacks**
```
"Try password spraying with common passwords against the discovered users"
```

4. **Bloodhound Analysis**
```
"Collect Bloodhound data ingest it, upload zip to bloodhound and find attack paths to Domain Admins"
```


## 🔧 Available Tools

### 🗺️ Nmap (Network Reconnaissance)
- `run_nmap_scan`: Network and service discovery with customizable flags

### ⚡ NetExec (SMB/LDAP Operations)
**SMB Enumeration & Authentication**:
- `check_SMB_signing`: Check SMB signing configuration
- `enumerate_domain_users`: Discover Active Directory users
- `bruteforce_rid_users`: RID cycling for user enumeration
- `password_spray`: Multi-target password attacks

**Kerberos Attacks**:
- `ASREPRoast`: Extract AS-REP hashes for offline cracking
- `kerberoast`: Extract TGS tickets for service accounts

**Post-Exploitation**:
- `spider_smb_shares`: Comprehensive share enumeration and file collection
- `dump_ntds_dit`: Extract domain credential database (NTDS.dit)
- `dump_sam_hashes`: Local account hash extraction
- `command_execution`: Remote PowerShell command execution

**Bloodhound Data Collection**:
- `bloodhound_ingest`: Collect AD data using NetExec's BloodHound module

**Module System**:
- `check_module`: List available NetExec modules for protocols (SMB, LDAP, WinRM, etc.)
- `check_options`: View module-specific options and parameters
- `use_module`: Execute NetExec modules with custom options

### 🩸 Bloodhound (Attack Path Analysis)
- `test_bloodhound_connection`: Verify API connectivity and version
- `upload_zip_to_bloodhound`: Import collected data into Bloodhound
- `list_saved_queries`: View saved Cypher queries
- `run_bloodhound_query`: Execute custom Cypher queries for attack path discovery

### 🔓 John the Ripper (Hash Cracking)
- `get_john_formats`: List available hash formats for cracking
- `john_the_ripper`: Crack hashes with specified format and wordlist

### 🏛️ Certipy (Certificate Services)
- `certipy_scan`: Enumerate AD CS vulnerabilities and misconfigurations

### 📝 Utility & Data Management
- `save_partial_finding`: Organize and store assessment results
- `get_project_directory_files`: View files in current project directory
- `read_files`: Access collected data and configuration files
- `generate_pwd_wordlist`: Create custom password wordlists based on target information
## 🔧 Available Resources
- `Custom Bloodhound Queries`: Some custom bloodhound queries that you can include as a resource to your MCP client.
Note that you can add any resources you want just follow this resource:
```python
@mcp.resource("data://bloodhound_cypher_queries")
def get_custom_queries():
    # Resolve path relative to this script (safer than relying on current working dir)
    p = Path(__file__).parent / "custom_bloodhound_queries.json"

    # use 'encoding' (not 'encode') and json.load for file -> python object (if  your data isn't json load it normally)
    with p.open("r", encoding="utf-8") as f:
        return json.load(f)

```



## 🔒 Security Considerations

### Responsible Use
- This tool is intended for authorized security assessments only
- Ensure proper authorization before testing any systems
- Follow responsible disclosure practices for discovered vulnerabilities


##  Troubleshooting

### Common Issues

**Clock Skew Errors**:
```bash
# Sync time with domain controller (requires root)
sudo ntpdate domain-controller.local

```

**Permission Errors**:
- Ensure NetExec has appropriate permissions
- Check that output directories are writable
- Verify Bloodhound API credentials

```

## 🤝 Contributing

### Adding New Tools


1. Create a new tool function following the MCP pattern
2. Add appropriate input validation
3. Update documentation and examples

```
[![MCP Badge](https://lobehub.com/badge/mcp/youssefsahnoun-pentestmcp?style=plastic)](https://lobehub.com/mcp/youssefsahnoun-pentestmcp)


