from .types import Model

_ANTHROPIC_MODELS = [
    Model(
        id="claude-opus-4-20250514",
        provider="claude",
        name="Claude 4 Opus",
        description="Anthropic's most capable and intelligent model yet. Claude Opus 4 sets new standards in complex reasoning and advanced coding",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=15.0,
        output_token_price_1m=75.0,
    ),
    Model(
        id="claude-sonnet-4-20250514",
        provider="claude",
        name="Claude 4 Sonnet",
        description="Anthropic's high-performance model with exceptional reasoning and efficiency",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=3.0,
        output_token_price_1m=15.0,
    ),
    Model(
        id="claude-sonnet-4-5",
        provider="claude",
        name="Claude 4.5 Sonnet",
        description="Anthropic's best coding model in the world",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=3.0,
        output_token_price_1m=15.0,
    ),
    Model(
        id="claude-3-7-sonnet-latest",
        provider="claude",
        name="Claude 3.7 Sonnet",
        description="Anthropic's most powerful model with advanced reasoning",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        default=True,
        input_token_price_1m=3.0,
        output_token_price_1m=15.0,
    ),
    Model(
        id="claude-3-5-sonnet-latest",
        provider="claude",
        name="Claude 3.5 Sonnet",
        description="Anthropic's Claude 3.5 Sonnet model - balanced performance and capabilities",
        capabilities=["tool_use", "vision", "stream"],
        input_token_price_1m=3.0,
        output_token_price_1m=15.0,
    ),
    Model(
        id="claude-3-5-haiku-latest",
        provider="claude",
        name="Claude 3.5 Haiku",
        description="Anthropic's fastest model",
        capabilities=["tool_use", "vision", "stream"],
        input_token_price_1m=0.8,
        output_token_price_1m=4.0,
    ),
]

_OPENAI_MODELS = [
    Model(
        id="gpt-5",
        provider="openai",
        name="GPT-5",
        description="GPT-5 is our flagship model for coding, reasoning, and agentic tasks across domains",
        capabilities=["tool_use", "vision", "thinking", "stream"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
        default=True,
    ),
    Model(
        id="gpt-5-codex",
        provider="openai",
        name="GPT-5 Codex",
        description="GPT-5-Codex is a version of GPT-5 optimized for agentic coding tasks in Codex or similar environments",
        capabilities=["tool_use", "vision", "thinking", "stream"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
        default=True,
    ),
    Model(
        id="gpt-4.1-mini",
        provider="openai",
        name="GPT-4.1 Mini",
        description="small, quick GPT model",
        capabilities=["tool_use", "vision", "stream"],
        input_token_price_1m=0.15,
        output_token_price_1m=0.6,
        default=True,
    ),
    Model(
        id="gpt-4.1",
        provider="openai",
        name="GPT-4.1",
        description="Flagship model for complex tasks. It is well suited for problem solving across domains",
        capabilities=["tool_use", "vision", "stream"],
        input_token_price_1m=2,
        output_token_price_1m=8,
        default=True,
    ),
    Model(
        id="o3-mini",
        provider="openai",
        name="GPT o3 mini",
        description="Fast, flexible, intelligent reasoning model",
        capabilities=["thinking", "stream"],
        input_token_price_1m=1.1,
        output_token_price_1m=4.4,
    ),
    Model(
        id="o4-mini",
        provider="openai",
        name="GPT o4 mini",
        description="o4-mini is our latest small o-series model. It's optimized for fast, effective reasoning with exceptionally efficient performance in coding and visual tasks.",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        input_token_price_1m=1.1,
        output_token_price_1m=4.4,
    ),
    Model(
        id="o3",
        provider="openai",
        name="GPT o3",
        description="a well-rounded and powerful model across domains. It sets a new standard for math, science, coding, and visual reasoning tasks. ",
        capabilities=["thinking", "tool_use", "vision", "stream"],
        input_token_price_1m=2.0,
        output_token_price_1m=8.0,
    ),
]

_GROQ_MODELS = [
    Model(
        id="compound-beta",
        provider="groq",
        name="Agentic Tooling model",
        description="Groq's first compound models with tooling",
        capabilities=["thinking"],
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="deepseek-r1-distill-llama-70b",
        provider="groq",
        name="DeepSeek R1 Distill",
        description="DeepSeek's powerful model optimized for Groq",
        capabilities=["thinking", "tool_use"],
        input_token_price_1m=0.75,
        output_token_price_1m=0.99,
    ),
    Model(
        id="llama-3.3-70b-versatile",
        provider="groq",
        name="Llama 3.3 70B",
        description="Meta's Llama 3 70B model optimized for Groq",
        capabilities=["tool_use"],
        input_token_price_1m=0.59,
        output_token_price_1m=0.79,
    ),
    Model(
        id="meta-llama/llama-4-scout-17b-16e-instruct",
        provider="groq",
        name="Llama 4 Scout",
        description="The Llama 4 collection of models are natively multimodal AI models that enable text and multimodal experiences. These models leverage a mixture-of-experts architecture to offer industry-leading performance in text and image understanding.",
        capabilities=["tool_use", "vision"],
        input_token_price_1m=0.11,
        output_token_price_1m=0.34,
    ),
    Model(
        id="meta-llama/llama-4-maverick-17b-128e-instruct",
        provider="groq",
        name="Llama 4 Maverick",
        description="The Llama 4 collection of models are natively multimodal AI models that enable text and multimodal experiences. These models leverage a mixture-of-experts architecture to offer industry-leading performance in text and image understanding.",
        capabilities=["tool_use"],
        input_token_price_1m=0.5,
        output_token_price_1m=0.77,
    ),
    Model(
        id="openai/gpt-oss-120b",
        provider="groq",
        name="GPT OSS 120B",
        description="OpenAI's flagship open-weight MoE model with 120B total parameters",
        capabilities=["tool_use"],
        default=False,
        input_token_price_1m=0.15,
        output_token_price_1m=0.75,
    ),
    Model(
        id="moonshotai/kimi-k2-instruct",
        provider="groq",
        name="Kimi K2 Instruct",
        description="Kimi K2 is Moonshot AI's state-of-the-art Mixture-of-Experts (MoE) language model with 1 trillion total parameters and 32 billion activated parameters",
        capabilities=["tool_use", "stream"],
        default=False,
        input_token_price_1m=1.0,
        output_token_price_1m=3.0,
    ),
]

_GOOGLE_MODELS = [
    Model(
        id="gemini-2.5-flash-lite-preview-06-17",
        provider="google",
        name="Gemini 2.5 Lite",
        description="Gemini 2.0 Flash Lite is low latancy, balanced language model from Google, designed for both text and visual inputs.",
        capabilities=["tool_use", "vision"],
        input_token_price_1m=0.1,
        output_token_price_1m=0.4,
    ),
    Model(
        id="gemini-2.5-flash",
        provider="google",
        name="Gemini 2.5 Flash ",
        description="Gemini 2.5 Flash is Google's first fully hybrid reasoning AI model, designed for high speed and cost-efficiency, allowing developers to toggle advanced reasoning on or off as needed.",
        capabilities=["tool_use", "vision", "thinking"],
        input_token_price_1m=0.3,
        output_token_price_1m=2.5,
        default=True,
    ),
    Model(
        id="gemini-2.5-pro",
        provider="google",
        name="Gemini 2.5 Pro Thinking",
        description="Gemini 2.5 Pro with thinking",
        capabilities=["tool_use", "thinking", "vision"],
        input_token_price_1m=1.25,
        output_token_price_1m=10,
    ),
]

_DEEPINFRA_MODELS = [
    Model(
        id="meta-llama/Llama-3.3-70B-Instruct",
        provider="deepinfra",
        name="Llama 3.3 70B Instruct",
        description="Llama 3.3-70B is a multilingual LLM trained on a massive dataset of 15 trillion tokens, fine-tuned for instruction-following and conversational dialogue",
        capabilities=["tool_use", "text-generation", "stream"],
        input_token_price_1m=0.23,
        output_token_price_1m=0.40,
    ),
    Model(
        id="google/gemma-3-27b-it",
        provider="deepinfra",
        name="Gemma 3 27B",
        description="Gemma is a family of lightweight, state-of-the-art open models from Google, built from the same research and technology used to create the Gemini models",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.1,
        output_token_price_1m=0.2,
    ),
    Model(
        id="openai/gpt-oss-120b",
        provider="deepinfra",
        name="GPT-OSS 120B",
        description="gpt-oss-120b is an open-weight, 117B-parameter Mixture-of-Experts (MoE) language model from OpenAI designed for high-reasoning, agentic, and general-purpose production use cases",
        capabilities=["text-generation", "tool_use", "stream", "thinking"],
        input_token_price_1m=0.09,
        output_token_price_1m=0.45,
    ),
    Model(
        id="Qwen/Qwen3-Coder-480B-A35B-Instruct",
        provider="deepinfra",
        name="Qwen 3 Coder",
        description="Qwen3-Coder-480B-A35B-Instruct is the Qwen3's most agentic code model",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.4,
        output_token_price_1m=1.6,
    ),
    Model(
        id="Qwen/Qwen3-235B-A22B",
        provider="deepinfra",
        name="Qwen 3 MoE 235B-22B",
        description="Qwen3 is the latest generation of large language models in Qwen series, offering a comprehensive suite of dense and mixture-of-experts (MoE) models",
        capabilities=["text-generation", "tool_use", "thinking", "stream"],
        input_token_price_1m=0.2,
        output_token_price_1m=0.6,
    ),
    Model(
        id="zai-org/GLM-4.6",
        provider="deepinfra",
        name="Zai GLM-4.6",
        description="The GLM-4.6 series models are foundation models designed for intelligent agents",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.6,
        output_token_price_1m=2.0,
    ),
    Model(
        id="Qwen/Qwen3-32B",
        provider="deepinfra",
        name="Qwen 3 32B",
        description="Qwen3 is the latest generation of large language models in Qwen series, offering a comprehensive suite of dense and mixture-of-experts (MoE) models",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.1,
        output_token_price_1m=0.3,
    ),
    Model(
        id="Qwen/QwQ-32B",
        provider="deepinfra",
        name="Qwen QwQ 32B",
        description="QwQ is the reasoning model of the Qwen series",
        capabilities=["text-generation", "stream", "thinking"],
        input_token_price_1m=0.15,
        output_token_price_1m=0.2,
    ),
    Model(
        id="deepseek-ai/DeepSeek-V3.1",
        provider="deepinfra",
        name="DeepSeek V3.1",
        description="DeepSeek-V3.1 is post-trained on the top of DeepSeek-V3.1-Base, which is built upon the original V3 base checkpoint through a two-phase long context extension approach",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.3,
        output_token_price_1m=1.0,
    ),
    Model(
        id="deepseek-ai/DeepSeek-R1-0528",
        provider="deepinfra",
        name="DeepSeek R1 0528",
        description="The DeepSeek R1 model has undergone a minor version upgrade, with the current version being DeepSeek-R1-0528.",
        capabilities=["text-generation", "tool_use", "thinking", "stream"],
        input_token_price_1m=0.5,
        output_token_price_1m=2.18,
    ),
    Model(
        id="moonshotai/Kimi-K2-Instruct",
        provider="deepinfra",
        name="Kimi K2 Instruct",
        description="Kimi K2 is a large-scale Mixture-of-Experts (MoE) language model developed by Moonshot AI, featuring 1 trillion total parameters with 32 billion active per forward pass",
        capabilities=["text-generation", "tool_use", "stream"],
        input_token_price_1m=0.55,
        output_token_price_1m=2.22,
    ),
]
_GITHUB_COPILOT_MODELS = [
    Model(
        id="claude-haiku-4.5",
        provider="github_copilot",
        name="Claude 4.5 Haiku",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gemini-2.5-pro",
        provider="github_copilot",
        name="Gemini 2.5 Pro",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-4.1",
        provider="github_copilot",
        name="GPT 4.1",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="grok-code-fast-1",
        provider="github_copilot",
        name="Grok Code Fast 1",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-4o",
        provider="github_copilot",
        name="GPT 4o",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5",
        provider="github_copilot",
        name="GPT 5",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="gpt-5-codex",
        provider="copilot_response",
        name="GPT 5 Codex",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
        endpoint="response",
    ),
    Model(
        id="gpt-5-mini",
        provider="github_copilot",
        name="GPT 5 mini",
        description="",
        capabilities=["tool_use", "vision", "stream", "thinking"],
        default=True,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="o1",
        provider="github_copilot",
        name="o1",
        description="",
        capabilities=["tool_use", "thinking", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-sonnet-4",
        provider="github_copilot",
        name="Claude Sonnet 4",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-sonnet-4.5",
        provider="github_copilot",
        name="Claude Sonnet 4.5",
        description="",
        capabilities=["tool_use", "vision", "stream"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
    Model(
        id="claude-opus-4.1",
        provider="github_copilot",
        name="Claude Opus 4.1 (Preview)",
        description="",
        capabilities=["tool_use", "vision", "stream", "thinking"],
        default=False,
        input_token_price_1m=0.0,
        output_token_price_1m=0.0,
    ),
]
AVAILABLE_MODELS = (
    _ANTHROPIC_MODELS
    + _OPENAI_MODELS
    + _GROQ_MODELS
    + _GOOGLE_MODELS
    + _DEEPINFRA_MODELS
    + _GITHUB_COPILOT_MODELS
)
