## Description

<!-- Provide a clear and concise description of your changes -->

## Type of Change

<!-- Mark the relevant option with an 'x' -->

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Refactoring (no functional changes)
- [ ] Performance improvement
- [ ] Test improvement

## Related Issues

<!-- Link to related issues using #issue_number -->

Closes #
Relates to #

## Changes Made

<!-- Provide a detailed list of changes -->

-
-
-

## Testing

<!-- Describe the testing you've done -->

### Test Coverage

- [ ] All existing tests pass
- [ ] New tests added for new features
- [ ] Contract tests updated (if applicable)
- [ ] Integration tests updated (if applicable)
- [ ] Unit tests updated (if applicable)
- [ ] Code coverage maintained or improved

### Manual Testing

<!-- Describe manual testing performed -->

**Test Environment**:
- OS:
- Python Version:
- Installation Method:

**Test Steps**:
1.
2.
3.

**Test Results**:
```
Paste test output or describe results
```

## Documentation

- [ ] README.md updated (if applicable)
- [ ] CONFIGURATION.md updated (if applicable)
- [ ] CHANGELOG.md updated
- [ ] Docstrings added/updated
- [ ] Code comments added for complex logic

## Checklist

<!-- Mark completed items with an 'x' -->

### Code Quality

- [ ] Code follows the project's style guidelines
- [ ] Self-review of code completed
- [ ] Code is well-commented, particularly in complex areas
- [ ] No unnecessary debug statements or console logs
- [ ] Type hints added for new functions

### Security

- [ ] No security vulnerabilities introduced
- [ ] Path validation properly implemented (if applicable)
- [ ] No sensitive data exposed in logs or code
- [ ] Security best practices followed

### Breaking Changes

- [ ] No breaking changes introduced
- [ ] Breaking changes documented in CHANGELOG.md (if applicable)
- [ ] Migration guide provided (if applicable)

### Dependencies

- [ ] No new dependencies added
- [ ] New dependencies justified and documented (if applicable)
- [ ] Dependencies updated in pyproject.toml (if applicable)

## Screenshots / Examples

<!-- If applicable, add screenshots or example outputs -->

<details>
<summary>Example Output</summary>

```json
{
  // Example JSON output or code examples
}
```
</details>

## Performance Impact

<!-- Describe any performance implications -->

- [ ] No significant performance impact
- [ ] Performance improved
- [ ] Performance impact documented and acceptable

## Additional Notes

<!-- Any additional information that reviewers should know -->

## Reviewer Checklist

<!-- For maintainers reviewing this PR -->

- [ ] Code review completed
- [ ] Tests reviewed and passing
- [ ] Documentation reviewed
- [ ] Breaking changes identified and documented
- [ ] Security implications reviewed
- [ ] Performance impact assessed
