# Developer Setup with uv

This project has been migrated from Poetry to uv (https://uv.pypa.io/).

## Quick Start

### Preparation
Install `uv` with the official installation script.

### 1. Create virtual environment

```bash
uv venv
```

### 2. Sync environment (install dependencies)

```bash
uv sync
```

### 3. Run the bot

```bash
source .venv/bin/activate
python -m optrabot.main --loglevel INFO
```

## Development Workflow

### Adding dependencies

Add to `pyproject.toml` under `[project]` dependencies, then:

```bash
uv lock
uv sync --active
```

### Updating lockfile

```bash
uv lock --upgrade
```

### Check environment sync

```bash
uv sync --active --check
```

## CI/CD Notes

- Use `uv sync --frozen` in CI to ensure deterministic installs from `uv.lock`
- Use `uv venv` to create environments in CI pipelines
- Example for GitHub Actions:
  ```yaml
  - name: Install uv
    run: curl -LsSf https://astral.sh/uv/install.sh | sh
  
  - name: Create venv and install dependencies
    run: |
      uv venv
      uv sync --frozen
  ```

## Migration from Poetry

The project was migrated from Poetry to uv on 2025-11-13:
- `poetry.lock` → `uv.lock`
- `[tool.poetry]` → `[project]` (PEP 621)
- `poetry install` → `uv sync`
- Build backend: `hatchling` (compatible with both tools)
