# OptraBot Dokumentation

Dieses Verzeichnis enthält die technische Dokumentation für OptraBot Features und Implementierungen.

## Feature Dokumentationen

### Flow Engine
- **[FLOWENGINE_IMPLEMENTATION.md](FLOWENGINE_IMPLEMENTATION.md)** - Implementierung der Flow Engine für automatisierte Workflows und Event-basierte Aktionen

### Trade Features
- **[TRADE_GROUPS_FEATURE.md](TRADE_GROUPS_FEATURE.md)** - Trade Grouping für zusammenhängende Positionen und Rollover-Strategien
- **[EXPIRATION_FEATURE.md](EXPIRATION_FEATURE.md)** - Handling von Expiration-Parametern in Trade Templates

## Jira Issue Dokumentationen

### OTB-254: PNL Correction
- **[OTB-254_PNL_CORRECTION.md](OTB-254_PNL_CORRECTION.md)**
- Korrektur der PNL-Berechnung bei Trade Groups
- Problem: Doppelte Addition von realizedPNL
- Fix: Berücksichtigung von tradeGroupId bei Rollover-Trades

### OTB-256: TWS Version Check
- **[OTB-256_TWS_VERSION_CHECK.md](OTB-256_TWS_VERSION_CHECK.md)**
- Implementation eines TWS Version Checks für SEC Compliance
- Enforcement Date: 3. November 2025
- Minimum TWS Version: 10.37 (API Version 176+)
- Zusätzliche Fixes:
  - SQLAlchemy Session Management bei Trade Opening
  - Log Level Anpassungen (One-time Corrections)
  - Windows Unicode Encoding Fix (UTF-8 für Emojis)

### OTB-257: Duplicate Order ID Race Condition
- **[OTB-257_DUPLICATE_ORDER_FIX.md](OTB-257_DUPLICATE_ORDER_FIX.md)**
- **KRITISCHER FIX**: Race Condition bei Duplicate Order IDs
- Problem: Unmanaged Trades nach Entry Order Adjustment
- Lösung: Replacement Orders werden zur Duplicate-Liste hinzugefügt
- Impact: Verhindert Verlust des Trade-Trackings

### OTB-259: EOD Settlement SQLAlchemy Fix
- **[OTB-259_EOD_SETTLEMENT_FIX.md](OTB-259_EOD_SETTLEMENT_FIX.md)**
- **KRITISCHER FIX**: AssertionError beim EOD Settlement
- Problem: Session-Inkonsistenz zwischen TradeHelper.updateTrade() und crud.update_trade()
- Lösung: Trade-Objekt nach updateTrade() neu laden
- Impact: Verhindert Crash beim Settlement von EXPIRED Trades

### OTB-258: NTP Time Synchronization
- **[OTB-258_TIME_SYNC.md](OTB-258_TIME_SYNC.md)**
- Zeitüberwachung mit NTP-Servern
- Problem: Systemzeit-Abweichungen können Trading-Logik beeinträchtigen
- Lösung: Automatische Prüfung beim Start und täglich
- Warnung per Telegram bei Abweichung > 30 Sekunden

## Struktur

```
doc/
├── README.md                           # Diese Datei
├── FLOWENGINE_IMPLEMENTATION.md        # Flow Engine Architektur
├── TRADE_GROUPS_FEATURE.md             # Trade Grouping
├── EXPIRATION_FEATURE.md               # Expiration Handling
├── OTB-254_PNL_CORRECTION.md           # PNL Fix
├── OTB-256_TWS_VERSION_CHECK.md        # TWS Version Check + Fixes
├── OTB-257_DUPLICATE_ORDER_FIX.md      # Duplicate Order Fix
├── OTB-258_TIME_SYNC.md                # NTP Time Synchronization
└── OTB-259_EOD_SETTLEMENT_FIX.md       # EOD Settlement Session Fix
```

## Kategorien

### 🔧 Features
- Flow Engine
- Trade Groups
- Expiration Handling
- OTB-258: Time Synchronization

### 🐛 Bugfixes
- OTB-254: PNL Calculation
- OTB-257: Duplicate Order Race Condition
- OTB-259: EOD Settlement Session Management

### ✅ Compliance
- OTB-256: TWS Version Check (SEC Rule RIN 3235-AN23)

### 🔒 Critical Fixes
- OTB-257: Verhindert unmanaged Trades
- OTB-259: Verhindert EOD Settlement Crash
- OTB-256: Session Management und Unicode Fixes

## Versions-Historie

| Version   | Issues        | Beschreibung                                      |
|-----------|---------------|---------------------------------------------------|
| 0.18.0a8  | OTB-258       | NTP Time Synchronization                          |
| 0.18.0a7  | OTB-259       | EOD Settlement Session Management Fix             |
| 0.18.0a5  | OTB-256, 257  | Merge to develop + cleanup                        |
| 0.18.0a4  | OTB-257       | Fix für Duplicate Order ID Race Condition        |
| 0.18.0a3  | OTB-256       | Windows Unicode Fix                               |
| 0.18.0a2  | OTB-256       | Log Level Anpassungen                             |
| 0.18.0a1  | OTB-256       | TWS Version Check, Session Fix                    |
| 0.17.0    | OTB-252, 254  | Trade Groups, PNL Correction                      |

## Weitere Dokumentation

- **[../README.md](../README.md)** - Haupt-README mit Projekt-Übersicht
- **[../optrabot/flowengine/README.md](../optrabot/flowengine/README.md)** - Flow Engine Code-Dokumentation
- **[../frontend/README.md](../frontend/README.md)** - Frontend-Dokumentation
