import UIComponent from "sap/ui/core/UIComponent";
import models from "./model/models";
import Device from "sap/ui/Device";
import JSONModel from "sap/ui/model/json/JSONModel";

/**
 * @namespace com.optrabot.ui
 */
export default class Component extends UIComponent {
	public static metadata = {
		manifest: "json",
	};

	private contentDensityClass: string;

	public async init(): void {
		// call the base component's init function
		super.init();

		// create the device model
		this.setModel(models.createDeviceModel(), "device");

		var oControlModel = new JSONModel();
		this.setModel(oControlModel, "control");

		// Initialisiere das global-Model
		await this.initializeGlobalModel();

		// create the views based on the url/hash
		this.getRouter().initialize();
	}

	/**
	 * Initializes the global model with the backend URL and the app version.
	 * @returns {Promise<void>}
	 */
	private async initializeGlobalModel(): Promise<void> {
		var environment = (window as any).environment || "PROD";
		var backendBaseUrl = "";
		backendBaseUrl = window.location.origin;
		if (environment !== "PROD") {
			// In development the backend uses a different port
			backendBaseUrl = backendBaseUrl.slice(0, backendBaseUrl.lastIndexOf(":"));
			backendBaseUrl = backendBaseUrl+ ":8080"
		}
		const globalData = {
			"backendBaseUrl": backendBaseUrl,
			"appVersion": "1.0.0"
		};
		const globalModel = new JSONModel(globalData);
		this.setModel(globalModel, "global");
	}

	/**
	 * This method can be called to determine whether the sapUiSizeCompact or sapUiSizeCozy
	 * design mode class should be set, which influences the size appearance of some controls.
	 * @public
	 * @returns css class, either 'sapUiSizeCompact' or 'sapUiSizeCozy' - or an empty string if no css class should be set
	 */
	public getContentDensityClass(): string {
		if (this.contentDensityClass === undefined) {
			// check whether FLP has already set the content density class; do nothing in this case
			if (document.body.classList.contains("sapUiSizeCozy") || document.body.classList.contains("sapUiSizeCompact")) {
				this.contentDensityClass = "";
			} else if (!Device.support.touch) {
				// apply "compact" mode if touch is not supported
				this.contentDensityClass = "sapUiSizeCompact";
			} else {
				// "cozy" in case of touch support; default for most sap.m controls, but needed for desktop-first controls like sap.ui.table.Table
				this.contentDensityClass = "sapUiSizeCozy";
			}
		}
		return this.contentDensityClass;
	}
}
