# OptraBot Windows Installer Script
# This script installs UV, Python 3.12, and OptraBot

$ErrorActionPreference = "Stop"

Write-Host "=== OptraBot Installer ===" -ForegroundColor Cyan
Write-Host ""

# Check if UV is already installed
$uvPath = "$env:USERPROFILE\.local\bin\uv.exe"
if (Test-Path $uvPath) {
    Write-Host "UV is already installed at: $uvPath" -ForegroundColor Green
} else {
    Write-Host "Step 1/3: Installing UV..." -ForegroundColor Yellow
    try {
        Invoke-RestMethod https://astral.sh/uv/install.ps1 | Invoke-Expression
        Write-Host "UV successfully installed!" -ForegroundColor Green
    } catch {
        Write-Host "Failed to install UV: $_" -ForegroundColor Red
        exit 1
    }
}

# Ensure UV is in the PATH for this session
$env:Path = "$env:USERPROFILE\.local\bin;" + $env:Path

Write-Host ""
Write-Host "Step 2/3: Installing Python 3.12..." -ForegroundColor Yellow
try {
    & $uvPath python install 3.12
    Write-Host "Python 3.12 successfully installed!" -ForegroundColor Green
} catch {
    Write-Host "Failed to install Python 3.12: $_" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "Step 3/3: Installing OptraBot..." -ForegroundColor Yellow
try {
    & $uvPath tool install --python 3.12 optrabot
    Write-Host "OptraBot successfully installed!" -ForegroundColor Green
} catch {
    Write-Host "Failed to install OptraBot: $_" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "=== Installation Complete! ===" -ForegroundColor Green
Write-Host ""

# Setup OptraBot working directory
$optrabotDir = "$env:USERPROFILE\OptraBot"
if (Test-Path $optrabotDir) {
    Write-Host "OptraBot working directory already exists at: $optrabotDir" -ForegroundColor Green
} else {
    Write-Host "OptraBot needs a working directory for configuration and database files." -ForegroundColor Yellow
    $createDir = Read-Host "Create OptraBot directory at '$optrabotDir'? (y/n)"
    if ($createDir -eq 'y' -or $createDir -eq 'Y') {
        try {
            New-Item -ItemType Directory -Path $optrabotDir -Force | Out-Null
            Write-Host "Created OptraBot directory: $optrabotDir" -ForegroundColor Green
        } catch {
            Write-Host "Failed to create directory: $_" -ForegroundColor Red
            Write-Host "You can manually create it later and start OptraBot from there." -ForegroundColor Yellow
        }
    } else {
        Write-Host "Skipped directory creation. You can create it manually later." -ForegroundColor Yellow
    }
}

Write-Host ""
Write-Host "To start OptraBot, run:" -ForegroundColor Cyan
Write-Host "  cd $optrabotDir" -ForegroundColor White
Write-Host "  optrabot" -ForegroundColor White
Write-Host ""
Write-Host "Note: You may need to restart your terminal or add the following to your PATH:" -ForegroundColor Yellow
Write-Host "  $env:USERPROFILE\.local\bin" -ForegroundColor White
Write-Host ""

# Ask if user wants to start OptraBot now
$response = Read-Host "Do you want to start OptraBot now? (y/n)"
if ($response -eq 'y' -or $response -eq 'Y') {
    Write-Host ""
    Write-Host "Starting OptraBot from $optrabotDir..." -ForegroundColor Cyan
    # Change to OptraBot directory and start
    Set-Location $optrabotDir
    & "$env:USERPROFILE\.local\bin\optrabot.exe"
}
