"use strict";

sap.ui.define(["sap/ui/model/json/JSONModel", "./BaseController"], function (JSONModel, __BaseController) {
  "use strict";

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule && typeof obj.default !== "undefined" ? obj.default : obj;
  }
  const BaseController = _interopRequireDefault(__BaseController);
  /**
   * @namespace com.optrabot.ui.controller
   */
  const Settings = BaseController.extend("com.optrabot.ui.controller.Settings", {
    onInit: function _onInit() {
      console.log("Settings controller initialized");
      this.oViewModel = new JSONModel({
        tastytradeSandbox: false,
        tastytradeClientId: ""
      });
      this.getView().setModel(this.oViewModel, "oViewModel");
    },
    onAuthorizePress: function _onAuthorizePress() {
      const globalModel = this.getOwnerComponent().getModel("global");
      const redirectUri = `${globalModel.getProperty("/backendBaseUrl")}/auth/tasty_callback`;
      const clientId = this.oViewModel.getProperty("/tastytradeClientId");
      const authUrl = `${this.getTastytradeAuthUrl()}?client_id=${clientId}&redirect_uri=${encodeURIComponent(redirectUri)}&response_type=code`;
      window.open(authUrl, 'tastyauth', 'width=500,height=500');
    },
    getTastytradeAuthUrl: function _getTastytradeAuthUrl() {
      const isSandbox = this.oViewModel.getProperty("/tastytradeSandbox");
      return isSandbox ? "https://cert-my.staging-tasty.works/auth.html" : "https://my.tastytrade.com/auth.html";
    }
  });
  return Settings;
});
//# sourceMappingURL=Settings-dbg.controller.js.map
