import unittest
import sys, os
import datetime as dt
sys.path.append(os.path.join(os.path.dirname(__file__), '../..'))
from optrabot.broker.ibtwsconnector import IBSymbolData, IBTWSTConnector
class IBTWSTests(unittest.TestCase):
	def setUp(self):
		self._cut = IBTWSTConnector()

	def test_determine_relevant_expirations(self):
		"""
		Test the determination of relevant expirations based on configured DTEs
		and expiration from IB symbol data.
		"""
		self._cut.set_dtes([0, 1, 2])
		
		current_date = dt.date.today()
		expirations = [
			current_date + dt.timedelta(days=0),
			current_date + dt.timedelta(days=1),
			current_date + dt.timedelta(days=4),
			current_date + dt.timedelta(days=5),
			current_date + dt.timedelta(days=6)
		]
		self._cut._symbolData = IBSymbolData()
		self._cut._symbolData.expirations = expirations
		relevant_expirations = self._cut._determine_relevant_expirations(self._cut._symbolData)
		expected_expirations = [
			current_date + dt.timedelta(days=0),  # Closest >= 0
			current_date + dt.timedelta(days=1),  # Closest >= 1
			current_date + dt.timedelta(days=4)   # Closest >= 2
		]
		self.assertEqual(relevant_expirations, expected_expirations)