import unittest
import sys, os
sys.path.append(os.path.join(os.path.dirname(__file__), '..'))

from optrabot.marketdatatype import MarketDataType

class MarketDataTypeTests(unittest.TestCase):
	def setUp(self):
		self._cut = MarketDataType(MarketDataType.Live)
	
	def test_byString(self):
		self._cut.byString('live')
		self.assertEquals(self._cut.Value, MarketDataType.Live, 'Expected Live Market Data Type')
		self._cut.byString('LiVe')
		self.assertEquals(self._cut.Value, MarketDataType.Live, 'Expected Live Market Data Type')
		self._cut.byString('delayed')
		self.assertEquals(self._cut.Value, MarketDataType.Delayed, 'Expected Delayed Market Data Type')
		self._cut.byString('DeLayeD')
		self.assertEquals(self._cut.Value, MarketDataType.Delayed, 'Expected Delayed Market Data Type')
		with self.assertRaises(ValueError):
			self._cut.byString('test')
		self.assertEquals(self._cut.Value, MarketDataType.Undefined)
	
	def test_toString(self):
		self.assertAlmostEquals(self._cut.toString(), 'Live', 'Expected Market Data Type Live')
		self._cut.byValue(MarketDataType.Delayed)
		self.assertAlmostEquals(self._cut.toString(), 'Delayed', 'Expected Market Data Type Delayed')
		with self.assertRaises(ValueError):
			self._cut.byValue(99)
		self.assertEquals(self._cut.Value, MarketDataType.Undefined, 'Expected Market Data Type Undefined')
	
	def test__invalidValue(self):
		with self.assertRaises(ValueError):
			self._cut._invalidValue(99)
		self.assertEquals(self._cut.Value, MarketDataType.Undefined, 'Expected Market Data Type Undefined')