import unittest
import sys, os
sys.path.append(os.path.join(os.path.dirname(__file__), '..'))

from optrabot.optionhelper import OptionHelper

class OptionHelperTests(unittest.TestCase):
	
	def test_roundToTickSize(self):
		self.assertEquals(OptionHelper.roundToTickSize(0.10), 0.10)
		self.assertEquals(OptionHelper.roundToTickSize(0.11), 0.10)
		self.assertEquals(OptionHelper.roundToTickSize(0.12), 0.10)
		self.assertEquals(OptionHelper.roundToTickSize(0.13), 0.15)
		self.assertEquals(OptionHelper.roundToTickSize(0.17), 0.15)
		self.assertEquals(OptionHelper.roundToTickSize(27.82, 10), 27.80)
		self.assertEquals(OptionHelper.roundToTickSize(27.85, 10), 27.90)
		self.assertEquals(OptionHelper.roundToTickSize(27.87, 10), 27.90)
		self.assertEquals(OptionHelper.roundToTickSize(27.83, 5), 27.85)
		self.assertEquals(OptionHelper.roundToTickSize(27.82, 5), 27.80)
		self.assertEquals(OptionHelper.roundToTickSize(25.15, 10), 25.20)

	def test_roundToStrikePrice(self):
		self.assertEquals(OptionHelper.roundToStrikePrice(4321.1), 4320)
		self.assertEquals(OptionHelper.roundToStrikePrice(4322.55), 4325)
		self.assertEquals(OptionHelper.roundToStrikePrice(4325.01), 4325)
		self.assertEquals(OptionHelper.roundToStrikePrice(4327.49), 4325)

	def test_calculateMidPrice(self):
		self.assertEquals(OptionHelper.calculateMidPrice(22.50, 21.50), 22)
		self.assertEquals(OptionHelper.calculateMidPrice(22.0, 22.0), 22)
		self.assertEquals(OptionHelper.calculateMidPrice(20.0, 22.0), 21)