from datetime import datetime, timedelta
import unittest
import sys, os
sys.path.append(os.path.join(os.path.dirname(__file__), '../..'))

from optrabot.tradetemplate.processor.templateprocessor import TemplateProcessor


class TemplateProcessorTests(unittest.TestCase):
	def test_isSignalOutdated(self):
		currentTime = datetime.now().astimezone()
		templateProcessor = TemplateProcessor()

		# None timestamp should be considered outdated
		self.assertTrue(templateProcessor._isSignalOutdated(None))

		# Signale zur aktuellen Zeit sollen gültig sein
		self.assertFalse(templateProcessor._isSignalOutdated(currentTime))

		# Signale mit zukünftiger Zeit sollen gültig sein
		time_delta = timedelta(seconds=5)
		signalTime = currentTime + time_delta
		self.assertFalse(templateProcessor._isSignalOutdated(signalTime))

		# Signale innerhalb von 10 Minuten in der Vergangenheit sollen gültig sein
		self.assertFalse(templateProcessor._isSignalOutdated(currentTime - timedelta(minutes=9, seconds=59)))

		# Signale älter als 10 Minuten sollen ungültig sein
		self.assertTrue(templateProcessor._isSignalOutdated(currentTime - timedelta(minutes=10, seconds=1)))
	