import sys, os
sys.path.append(os.path.join(os.path.dirname(__file__), '..'))
from optrabot.tradetemplate.templatefactory import IronFly
import unittest
from optrabot.tradinghubclient import TradinghubClient
import datetime
from datetime import timedelta
from loguru import logger
from ruyaml import YAML

class TradingHubClientTests(unittest.TestCase):
	def setUp(self):
		self.dummy = 'sdsds'
		self.tradingHubClient = TradinghubClient(None)

	def test_parseTimestamp(self):
		parsedTime = self.tradingHubClient._parseTimestamp('2023/21/12T22:35:11')
		self.assertIsNone(parsedTime, msg = 'Expected None')

		parsedTime = self.tradingHubClient._parseTimestamp('2023-11-07T21:14:00Z')
		expectedTime = datetime.datetime(2023, 11, 7,21,14,0,0, datetime.timezone.utc)
		self.assertEqual(parsedTime, expectedTime)
	
	def test_meetsMinimumPremium(self):
		ironFly = IronFly('Test')
		ironFly.minPremium = 0
		self.tradingHubClient._currentTemplate = ironFly
		self.assertEqual(self.tradingHubClient._meetsMinimumPremium(1), False)
		self.assertEqual(self.tradingHubClient._meetsMinimumPremium(-0.01), True)
		
		ironFly.minPremium = 15.0
		self.assertEqual(self.tradingHubClient._meetsMinimumPremium(-14.99), False)
		self.assertEqual(self.tradingHubClient._meetsMinimumPremium(-15), True)
		self.assertEqual(self.tradingHubClient._meetsMinimumPremium(-20), True)
