from clipped.compact.pydantic import model_rebuild

from polyaxon._flow.builds import V1Build
from polyaxon._flow.cache import V1Cache
from polyaxon._flow.component import V1Component
from polyaxon._flow.dags import DagOpSpec
from polyaxon._flow.early_stopping import (
    V1DiffStoppingPolicy,
    V1FailureEarlyStopping,
    V1MedianStoppingPolicy,
    V1MetricEarlyStopping,
    V1TruncationStoppingPolicy,
)
from polyaxon._flow.environment import V1Environment
from polyaxon._flow.events import V1EventKind, V1EventTrigger
from polyaxon._flow.hooks import V1Hook
from polyaxon._flow.init import V1Init
from polyaxon._flow.io import V1IO
from polyaxon._flow.joins import V1Join, V1JoinParam
from polyaxon._flow.matrix import (
    AcquisitionFunctions,
    GaussianProcessConfig,
    GaussianProcessesKernels,
    MatrixMixin,
    UtilityFunctionConfig,
    V1Bayes,
    V1GridSearch,
    V1HpChoice,
    V1HpDateRange,
    V1HpDateTimeRange,
    V1HpGeomSpace,
    V1HpLinSpace,
    V1HpLogNormal,
    V1HpLogSpace,
    V1HpLogUniform,
    V1HpNormal,
    V1HpPChoice,
    V1HpQLogNormal,
    V1HpQLogUniform,
    V1HpQNormal,
    V1HpQUniform,
    V1HpRange,
    V1HpUniform,
    V1Hyperband,
    V1Hyperopt,
    V1Iterative,
    V1Mapping,
    V1Matrix,
    V1MatrixKind,
    V1RandomSearch,
    V1Tuner,
    validate_pchoice,
)
from polyaxon._flow.mounts import V1ArtifactsMount
from polyaxon._flow.notifications import V1Notification
from polyaxon._flow.operations import V1CompiledOperation, V1Operation
from polyaxon._flow.optimization import (
    V1Optimization,
    V1OptimizationMetric,
    V1OptimizationResource,
    V1ResourceType,
)
from polyaxon._flow.params import ParamSpec, V1Param, ops_params
from polyaxon._flow.plugins import V1Plugins
from polyaxon._flow.references import RefMixin, V1DagRef, V1HubRef, V1PathRef, V1UrlRef
from polyaxon._flow.run import (
    MXJobMode,
    RunMixin,
    V1CleanerJob,
    V1CleanPodPolicy,
    V1CloningKind,
    V1Dag,
    V1DaskJob,
    V1DaskReplica,
    V1Job,
    V1KFReplica,
    V1MPIJob,
    V1MXJob,
    V1NotifierJob,
    V1PaddleElasticPolicy,
    V1PaddleJob,
    V1PipelineKind,
    V1PytorchElasticPolicy,
    V1PytorchJob,
    V1RayJob,
    V1RayReplica,
    V1RunEdgeKind,
    V1RunKind,
    V1RunPending,
    V1RunResources,
    V1Runtime,
    V1SchedulingPolicy,
    V1Service,
    V1TFJob,
    V1TunerJob,
    V1XGBoostJob,
    validate_run_patch,
)
from polyaxon._flow.schedules import (
    ScheduleMixin,
    V1CronSchedule,
    V1DateTimeSchedule,
    V1IntervalSchedule,
    V1ScheduleKind,
)
from polyaxon._flow.templates import V1Template
from polyaxon._flow.termination import V1Termination
from polyaxon._flow.trigger_policies import V1TriggerPolicy

# Forward references for operations and components
model_rebuild(V1Dag, V1Operation=V1Operation, V1Component=V1Component)
