from shards import logger

from pathlib import Path
from shutil import rmtree

rmtree("tmp/log")
test_logger = logger("Test", do_log_saving=True, log_save_folder="tmp/log")
child_logger = test_logger.make_child_logger("child")
log_file = Path(test_logger.save_folder) / f"{test_logger.start_timestamp}.log"

def test_log_messages():
    test_logger.raw("raw")
    test_logger.info("info")
    test_logger.warn("warn")
    test_logger.error("error")
    test_logger.critical("critical")

    with open(log_file, "r") as f:
        lines = f.readlines()

    assert lines[0].strip() == "raw"
    assert "( Test ) | [INFO] info" in lines[1]
    assert "( Test ) | [WARN] warn" in lines[2]
    assert "( Test ) | [ERROR] error" in lines[3]
    assert "( Test ) | [CRITICAL] critical" in lines[4]

def test_child_logger_messages():

    child_logger.info("info - child")

    with open(log_file, "r") as f:
        lines = f.readlines()

    assert "( Test/child ) | [INFO] info - child" in lines[5]