"""Create users, oauth2 applications, and oauth2 access tokens

Revision ID: 97ff9f55a3c0
Revises: 1d8e65aeefdd
Create Date: 2023-01-31 21:19:33.645918

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '97ff9f55a3c0'
down_revision = '1d8e65aeefdd'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('user',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('avatar', sa.String(length=255), nullable=True),
    sa.Column('email', sa.String(length=255), nullable=True),
    sa.Column('first_name', sa.String(length=255), nullable=True),
    sa.Column('last_name', sa.String(length=255), nullable=True),
    sa.Column('owner', sa.Boolean(), nullable=True),
    sa.Column('password_hash', sa.String(length=255), nullable=True),
    sa.Column('password_salt', sa.String(length=255), nullable=True),
    sa.Column('roles', sa.Integer(), nullable=True),
    sa.Column('username', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('oauth2_application',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('authorization_grant_type', sa.Enum('AUTHORIZATION_CODE', 'CLIENT_CREDENTIALS', name='authorizationgranttype'), nullable=True),
    sa.Column('client_id', sa.String(length=255), nullable=True),
    sa.Column('client_type', sa.Enum('PRIVATE', 'PUBLIC', name='clienttype'), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('redirect_uris', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('oauth2_access_token',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('expires', sa.DateTime(timezone=True), nullable=True),
    sa.Column('oauth2_application_id', sa.Integer(), nullable=True),
    sa.Column('token', sa.String(length=255), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['oauth2_application_id'], ['oauth2_application.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('oauth2_access_token')
    op.drop_table('oauth2_application')
    op.drop_table('user')
    # ### end Alembic commands ###
